package com.temboo.Library.UnlockPlaces;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SpacialFeaturesSearch

Searches for feature types within a specified bounding box.
*/
public class SpacialFeaturesSearch extends Choreography {

	/**
	Create a new instance of the SpacialFeaturesSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SpacialFeaturesSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/UnlockPlaces/SpacialFeaturesSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SpacialFeaturesSearchInputSet
	*/
	public SpacialFeaturesSearchInputSet newInputSet() {
		return new SpacialFeaturesSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SpacialFeaturesSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SpacialFeaturesSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SpacialFeaturesSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SpacialFeaturesSearchInputSet extends InputSet {
		/** 
		Set the value of the FeatureType input for this Choreo. 

		@param String - (string) The feature type that the place is (i.e. "Cities"). See http://unlock.edina.ac.uk/ws/supportedFeatureTypes?format=txt for a complete list of supported Feature Types.
		*/
		public void set_FeatureType(String value) {
			this.setInput("FeatureType", value);
		}


		/** 
		Set the value of the Format input for this Choreo. 

		@param String - (optional, string) The format of the place search results. One of xml, kml, json, georss or txt. Defaults to "xml".
		*/
		public void set_Format(String value) {
			this.setInput("Format", value);
		}


		/** 
		Set the value of the Gazetteer input for this Choreo. 

		@param String - (optional, string) The place-name source to take locations from. The options are geonames, os, naturalearth or unlock which combines all the previous. Defaults to "unlock".
		*/
		public void set_Gazetteer(String value) {
			this.setInput("Gazetteer", value);
		}


		/** 
		Set the value of the MaxLatitude input for this Choreo. 

		@param BigDecimal - (decimal) The maximum latitude point of a bounding box.
		*/
		public void set_MaxLatitude(BigDecimal value) {
			this.setInput("MaxLatitude", value);
		}

		/** 
		Set the value of the MaxLatitude input for this Choreo as a String. 

		@param String - (decimal) The maximum latitude point of a bounding box.
		*/
		public void set_MaxLatitude(String value) {
			this.setInput("MaxLatitude", value);	
		}
		/** 
		Set the value of the MaxLongitude input for this Choreo. 

		@param BigDecimal - (decimal) The maximum longitude point of a bounding box.
		*/
		public void set_MaxLongitude(BigDecimal value) {
			this.setInput("MaxLongitude", value);
		}

		/** 
		Set the value of the MaxLongitude input for this Choreo as a String. 

		@param String - (decimal) The maximum longitude point of a bounding box.
		*/
		public void set_MaxLongitude(String value) {
			this.setInput("MaxLongitude", value);	
		}
		/** 
		Set the value of the MaxRows input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of results to return. Defaults to 20. Cannot exceed 1000.
		*/
		public void set_MaxRows(Integer value) {
			this.setInput("MaxRows", value);
		}

		/** 
		Set the value of the MaxRows input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of results to return. Defaults to 20. Cannot exceed 1000.
		*/
		public void set_MaxRows(String value) {
			this.setInput("MaxRows", value);	
		}
		/** 
		Set the value of the MinLatitude input for this Choreo. 

		@param BigDecimal - (decimal) The minimum latitude point of a bounding box.
		*/
		public void set_MinLatitude(BigDecimal value) {
			this.setInput("MinLatitude", value);
		}

		/** 
		Set the value of the MinLatitude input for this Choreo as a String. 

		@param String - (decimal) The minimum latitude point of a bounding box.
		*/
		public void set_MinLatitude(String value) {
			this.setInput("MinLatitude", value);	
		}
		/** 
		Set the value of the MinLongitude input for this Choreo. 

		@param BigDecimal - (decimal) The minimum longitude point of a bounding box.
		*/
		public void set_MinLongitude(BigDecimal value) {
			this.setInput("MinLongitude", value);
		}

		/** 
		Set the value of the MinLongitude input for this Choreo as a String. 

		@param String - (decimal) The minimum longitude point of a bounding box.
		*/
		public void set_MinLongitude(String value) {
			this.setInput("MinLongitude", value);	
		}
		/** 
		Set the value of the Operator input for this Choreo. 

		@param String - Valid values are: "within" and "intersect". The results will therefore be entirely within, or overlapping with (intersecting), the bounding box. Defaults to "within".
		*/
		public void set_Operator(String value) {
			this.setInput("Operator", value);
		}


		/** 
		Set the value of the StartRow input for this Choreo. 

		@param Integer - (optional, integer) The row to start results display from. Defaults to 1.
		*/
		public void set_StartRow(Integer value) {
			this.setInput("StartRow", value);
		}

		/** 
		Set the value of the StartRow input for this Choreo as a String. 

		@param String - (optional, integer) The row to start results display from. Defaults to 1.
		*/
		public void set_StartRow(String value) {
			this.setInput("StartRow", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SpacialFeaturesSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SpacialFeaturesSearchResultSet extends ResultSet {
		public SpacialFeaturesSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) The response from Unlock. Defaults to XML based on the format input parameter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
