package com.temboo.Library.NYTimes.CampaignFinance.Committees;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CommitteeSearch

Search for a political action committee (PACs) by name, or partial name.
*/
public class CommitteeSearch extends Choreography {

	/**
	Create a new instance of the CommitteeSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CommitteeSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/CampaignFinance/Committees/CommitteeSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CommitteeSearchInputSet
	*/
	public CommitteeSearchInputSet newInputSet() {
		return new CommitteeSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CommitteeSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CommitteeSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CommitteeSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CommitteeSearchInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CampaignCycle input for this Choreo. 

		@param Integer - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year. 
		*/
		public void set_CampaignCycle(Integer value) {
			this.setInput("CampaignCycle", value);
		}

		/** 
		Set the value of the CampaignCycle input for this Choreo as a String. 

		@param String - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year. 
		*/
		public void set_CampaignCycle(String value) {
			this.setInput("CampaignCycle", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) Specify the name of the committee to be retireved. Partial names are also acceptable.  Examples: viacom.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Enter json or xml.  Default is json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CommitteeSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CommitteeSearchResultSet extends ResultSet {
		public CommitteeSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API corresponds to the setting (json, or xml) entered in the ResponseFormat variable.  Default is set to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
