package com.temboo.Library.Disqus.Threads;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateThread

Creates a new thread.
*/
public class CreateThread extends Choreography {

	/**
	Create a new instance of the CreateThread Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateThread(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Disqus/Threads/CreateThread"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateThreadInputSet
	*/
	public CreateThreadInputSet newInputSet() {
		return new CreateThreadInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateThreadResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateThreadResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateThread
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateThreadInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) A valid OAuth 2.0 access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (optional, string) The id of a category associated with the thread being created.
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (optional, date) The date to be associated with this thread (as a unix timestamp or ISO datetime format).
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the Forum input for this Choreo. 

		@param String - (required, string) Forum Short Name (i.e., the subdomain of the Disqus Site URL).
		*/
		public void set_Forum(String value) {
			this.setInput("Forum", value);
		}


		/** 
		Set the value of the Identifier input for this Choreo. 

		@param String - (optional, string) An optional string identifier for the thread. Maximum length is 300.
		*/
		public void set_Identifier(String value) {
			this.setInput("Identifier", value);
		}


		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (optional, string) A message for the new thread.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the PublicKey input for this Choreo. 

		@param String - (required, string) The Public Key provided by Disqus (AKA the API Key).
		*/
		public void set_PublicKey(String value) {
			this.setInput("PublicKey", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (required, string) The title of the thread.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (optional, string) A URL to be associated with the thread. Maximum length is 500.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateThread Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateThreadResultSet extends ResultSet {
		public CreateThreadResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) 
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
