package com.temboo.Library.Disqus.Posts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ReportPost

Report (flag) a post.
*/
public class ReportPost extends Choreography {

	/**
	Create a new instance of the ReportPost Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ReportPost(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Disqus/Posts/ReportPost"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ReportPostInputSet
	*/
	public ReportPostInputSet newInputSet() {
		return new ReportPostInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ReportPostResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ReportPostResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ReportPost
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ReportPostInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) A valid OAuth 2.0 access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the PostID input for this Choreo. 

		@param Integer - (required, integer) The post ID which is to be reported (flagged).
		*/
		public void set_PostID(Integer value) {
			this.setInput("PostID", value);
		}

		/** 
		Set the value of the PostID input for this Choreo as a String. 

		@param String - (required, integer) The post ID which is to be reported (flagged).
		*/
		public void set_PostID(String value) {
			this.setInput("PostID", value);	
		}
		/** 
		Set the value of the PublicKey input for this Choreo. 

		@param String - (required, string) The Public Key provided by Disqus (AKA the API Key).
		*/
		public void set_PublicKey(String value) {
			this.setInput("PublicKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and jsonp.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ReportPost Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ReportPostResultSet extends ResultSet {
		public ReportPostResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Disqus.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
