package com.temboo.Library.Wordnik.Account;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetWordLists

Retrieves the word lists for the specified user.
*/
public class GetWordLists extends Choreography {

	/**
	Create a new instance of the GetWordLists Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetWordLists(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wordnik/Account/GetWordLists"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetWordListsInputSet
	*/
	public GetWordListsInputSet newInputSet() {
		return new GetWordListsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetWordListsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetWordListsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetWordLists
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetWordListsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from Wordnik.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Maximum number of results to return. Defaults to 50.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Maximum number of results to return. Defaults to 50.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, string) The Password of the Wordnik account.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Response can be either JSON or XML. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the Skip input for this Choreo. 

		@param Integer - (optional, integer) Number of results to skip. Defaults to 0.
		*/
		public void set_Skip(Integer value) {
			this.setInput("Skip", value);
		}

		/** 
		Set the value of the Skip input for this Choreo as a String. 

		@param String - (optional, integer) Number of results to skip. Defaults to 0.
		*/
		public void set_Skip(String value) {
			this.setInput("Skip", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The Username of the Wordnik account.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetWordLists Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetWordListsResultSet extends ResultSet {
		public GetWordListsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Wordnik.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
