package com.temboo.Library.Fitbit.Body;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateBodyWeightGoal

Creates or updates a user's weight goal.
*/
public class UpdateBodyWeightGoal extends Choreography {

	/**
	Create a new instance of the UpdateBodyWeightGoal Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateBodyWeightGoal(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Fitbit/Body/UpdateBodyWeightGoal"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateBodyWeightGoalInputSet
	*/
	public UpdateBodyWeightGoalInputSet newInputSet() {
		return new UpdateBodyWeightGoalInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateBodyWeightGoalResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateBodyWeightGoalResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateBodyWeightGoal
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateBodyWeightGoalInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Fitbit.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The Consumer Secret provided by Fitbit.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that you want the response to be in: xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (required, date) Weight goal start date; in the format yyyy-MM-dd.
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the StartWeight input for this Choreo. 

		@param BigDecimal - (required, decimal) Weight goal start weight; in the format X.XX.
		*/
		public void set_StartWeight(BigDecimal value) {
			this.setInput("StartWeight", value);
		}

		/** 
		Set the value of the StartWeight input for this Choreo as a String. 

		@param String - (required, decimal) Weight goal start weight; in the format X.XX.
		*/
		public void set_StartWeight(String value) {
			this.setInput("StartWeight", value);	
		}
		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


		/** 
		Set the value of the Weight input for this Choreo. 

		@param BigDecimal - (conditional, decimal) Weight goal target weight; in the format X.XX. Required if user doesn't have a weight goal.
		*/
		public void set_Weight(BigDecimal value) {
			this.setInput("Weight", value);
		}

		/** 
		Set the value of the Weight input for this Choreo as a String. 

		@param String - (conditional, decimal) Weight goal target weight; in the format X.XX. Required if user doesn't have a weight goal.
		*/
		public void set_Weight(String value) {
			this.setInput("Weight", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateBodyWeightGoal Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateBodyWeightGoalResultSet extends ResultSet {
		public UpdateBodyWeightGoalResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Fitbit.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
