package com.temboo.Library.DuckDuckGo;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Query

Access DuckDuckGo web search functionality.  
*/
public class Query extends Choreography {

	/**
	Create a new instance of the Query Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Query(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DuckDuckGo/Query"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return QueryInputSet
	*/
	public QueryInputSet newInputSet() {
		return new QueryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public QueryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new QueryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Query
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class QueryInputSet extends InputSet {
		/** 
		Set the value of the Format input for this Choreo. 

		@param String - (optional, string) Enter: xml, or json.  Default is set to xml.
		*/
		public void set_Format(String value) {
			this.setInput("Format", value);
		}


		/** 
		Set the value of the NoHTML input for this Choreo. 

		@param Integer - (optional, integer) Enter 1 to remove HTML from text. Set only if Format=json.
		*/
		public void set_NoHTML(Integer value) {
			this.setInput("NoHTML", value);
		}

		/** 
		Set the value of the NoHTML input for this Choreo as a String. 

		@param String - (optional, integer) Enter 1 to remove HTML from text. Set only if Format=json.
		*/
		public void set_NoHTML(String value) {
			this.setInput("NoHTML", value);	
		}
		/** 
		Set the value of the NoRedirect input for this Choreo. 

		@param Integer - (optional, integer) Enter 1 to skip HTTP redirects.  This is useful for !bang commands. Set only if Format=json.
		*/
		public void set_NoRedirect(Integer value) {
			this.setInput("NoRedirect", value);
		}

		/** 
		Set the value of the NoRedirect input for this Choreo as a String. 

		@param String - (optional, integer) Enter 1 to skip HTTP redirects.  This is useful for !bang commands. Set only if Format=json.
		*/
		public void set_NoRedirect(String value) {
			this.setInput("NoRedirect", value);	
		}
		/** 
		Set the value of the PrettyPrint input for this Choreo. 

		@param Integer - (optional, integer) Enter 1 to pretty-print the JSON output.
		*/
		public void set_PrettyPrint(Integer value) {
			this.setInput("PrettyPrint", value);
		}

		/** 
		Set the value of the PrettyPrint input for this Choreo as a String. 

		@param String - (optional, integer) Enter 1 to pretty-print the JSON output.
		*/
		public void set_PrettyPrint(String value) {
			this.setInput("PrettyPrint", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (required, string) Enter a search query.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the SkipDisambiguation input for this Choreo. 

		@param Integer - (optional, integer) Enter 1 to skip disambiguation. Set only if Format=json.
		*/
		public void set_SkipDisambiguation(Integer value) {
			this.setInput("SkipDisambiguation", value);
		}

		/** 
		Set the value of the SkipDisambiguation input for this Choreo as a String. 

		@param String - (optional, integer) Enter 1 to skip disambiguation. Set only if Format=json.
		*/
		public void set_SkipDisambiguation(String value) {
			this.setInput("SkipDisambiguation", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Query Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class QueryResultSet extends ResultSet {
		public QueryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from DuckDuckGo in XML or JSON format.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
