package com.temboo.Library.Uber.Estimates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTimeEstimates

Returns ETAs for all products offered at a given location.
*/
public class GetTimeEstimates extends Choreography {

	/**
	Create a new instance of the GetTimeEstimates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTimeEstimates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Uber/Estimates/GetTimeEstimates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTimeEstimatesInputSet
	*/
	public GetTimeEstimatesInputSet newInputSet() {
		return new GetTimeEstimatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTimeEstimatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTimeEstimatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTimeEstimates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTimeEstimatesInputSet extends InputSet {
		/** 
		Set the value of the CustomerID input for this Choreo. 

		@param String - (optional, string) The ID of a customer to be used for experience customization.
		*/
		public void set_CustomerID(String value) {
			this.setInput("CustomerID", value);
		}


		/** 
		Set the value of the ProductID input for this Choreo. 

		@param String - (optional, string) An ID representing a specific product for a given latitude and longitude.
		*/
		public void set_ProductID(String value) {
			this.setInput("ProductID", value);
		}


		/** 
		Set the value of the ServerToken input for this Choreo. 

		@param String - (required, string) The Sever Token provided by Uber.
		*/
		public void set_ServerToken(String value) {
			this.setInput("ServerToken", value);
		}


		/** 
		Set the value of the StartLatitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude coordinate for the starting location e.g., 40.71863.
		*/
		public void set_StartLatitude(BigDecimal value) {
			this.setInput("StartLatitude", value);
		}

		/** 
		Set the value of the StartLatitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude coordinate for the starting location e.g., 40.71863.
		*/
		public void set_StartLatitude(String value) {
			this.setInput("StartLatitude", value);	
		}
		/** 
		Set the value of the StartLongitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude coordinate for the starting location e.g., -74.005584.
		*/
		public void set_StartLongitude(BigDecimal value) {
			this.setInput("StartLongitude", value);
		}

		/** 
		Set the value of the StartLongitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude coordinate for the starting location e.g., -74.005584.
		*/
		public void set_StartLongitude(String value) {
			this.setInput("StartLongitude", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTimeEstimates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTimeEstimatesResultSet extends ResultSet {
		public GetTimeEstimatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Uber.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
