package com.temboo.Library.Factual;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FilterRestaurantsByCuisineAndCoordinates

Find restaurants by cuisine and near specified latitude, longitude coordinates.
*/
public class FilterRestaurantsByCuisineAndCoordinates extends Choreography {

	/**
	Create a new instance of the FilterRestaurantsByCuisineAndCoordinates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FilterRestaurantsByCuisineAndCoordinates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Factual/FilterRestaurantsByCuisineAndCoordinates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FilterRestaurantsByCuisineAndCoordinatesInputSet
	*/
	public FilterRestaurantsByCuisineAndCoordinatesInputSet newInputSet() {
		return new FilterRestaurantsByCuisineAndCoordinatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FilterRestaurantsByCuisineAndCoordinatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FilterRestaurantsByCuisineAndCoordinatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FilterRestaurantsByCuisineAndCoordinates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FilterRestaurantsByCuisineAndCoordinatesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The API Key provided by Factual (AKA the OAuth Consumer Key).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (optional, string) The API Secret provided by Factual (AKA the OAuth Consumer Secret).
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Cuisine input for this Choreo. 

		@param String - (required, string) Enter a desired cuisine to narrow the search results. See Choreo doc for a list of available cuisine parameters.
		*/
		public void set_Cuisine(String value) {
			this.setInput("Cuisine", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Enter latitude coordinates of the location defining the center of the search radius.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) Enter latitude coordinates of the location defining the center of the search radius.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Enter longitude coordinates of the location defining the center of the search radius.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) Enter longitude coordinates of the location defining the center of the search radius.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Radius input for this Choreo. 

		@param Integer - (required, integer) Provide the radius (in meters, and centered on the latitude-longitude coordinates specified) for which search results will be returned.
		*/
		public void set_Radius(Integer value) {
			this.setInput("Radius", value);
		}

		/** 
		Set the value of the Radius input for this Choreo as a String. 

		@param String - (required, integer) Provide the radius (in meters, and centered on the latitude-longitude coordinates specified) for which search results will be returned.
		*/
		public void set_Radius(String value) {
			this.setInput("Radius", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FilterRestaurantsByCuisineAndCoordinates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FilterRestaurantsByCuisineAndCoordinatesResultSet extends ResultSet {
		public FilterRestaurantsByCuisineAndCoordinatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Factual.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
