package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PutBucketWebsiteRedirect

Configures the specified bucket as a website and sets the web request redirects to a designated endpoint.
*/
public class PutBucketWebsiteRedirect extends Choreography {

	/**
	Create a new instance of the PutBucketWebsiteRedirect Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PutBucketWebsiteRedirect(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/PutBucketWebsiteRedirect"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutBucketWebsiteRedirectInputSet
	*/
	public PutBucketWebsiteRedirectInputSet newInputSet() {
		return new PutBucketWebsiteRedirectInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutBucketWebsiteRedirectResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutBucketWebsiteRedirectResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PutBucketWebsiteRedirect
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutBucketWebsiteRedirectInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket that you wish to configure.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the CustomWebsiteRedirection input for this Choreo. 

		@param String - (optional, xml) A custom xml file for adding advanced website redirection rule(s). See description and Amazon  docs for details. Note - inputting a custom xml file will overwrite all other optional input values.
		*/
		public void set_CustomWebsiteRedirection(String value) {
			this.setInput("CustomWebsiteRedirection", value);
		}


		/** 
		Set the value of the ErrorDocument input for this Choreo. 

		@param String - (optional, string) The object key name to use when a 4XX class error occurs. Returns specified page when such an error occurs. Ex.: Error.html.
		*/
		public void set_ErrorDocument(String value) {
			this.setInput("ErrorDocument", value);
		}


		/** 
		Set the value of the HostName input for this Choreo. 

		@param String - (optional, string) Name of the host where requests will be redirected. Used when setting redirect rules, optional if specifying ReplaceKeyPrefixWith or ReplaceKeyWith input variables). Ex.: example.com.
		*/
		public void set_HostName(String value) {
			this.setInput("HostName", value);
		}


		/** 
		Set the value of the HttpErrorCodeReturnedEquals input for this Choreo. 

		@param String - (optional, string) The HTTP error code condition for which a redirect occurs. If there's an error and the error code equals this value, then the specified redirect is applied. Can use with KeyPrefixEquals. Ex:  404.
		*/
		public void set_HttpErrorCodeReturnedEquals(String value) {
			this.setInput("HttpErrorCodeReturnedEquals", value);
		}


		/** 
		Set the value of the HttpRedirectCode input for this Choreo. 

		@param String - (optional, string) The HTTP redirect code to use on the response.
		*/
		public void set_HttpRedirectCode(String value) {
			this.setInput("HttpRedirectCode", value);
		}


		/** 
		Set the value of the KeyPrefixEquals input for this Choreo. 

		@param String - (optional, string) The name or prefix condition of the object that will trigger the redirect action. Can use with HttpErrorCodeReturnedEquals. Ex:  Single page: ExamplePage.html, All pages with prefix: /images.
		*/
		public void set_KeyPrefixEquals(String value) {
			this.setInput("KeyPrefixEquals", value);
		}


		/** 
		Set the value of the Protocol input for this Choreo. 

		@param String - (optional, string) Sets protocol to use when redirecting requests. Optional if you are specifying either ReplaceKeyPrefixWith or ReplaceKeyWith optional inputs. Possible values: http, https.
		*/
		public void set_Protocol(String value) {
			this.setInput("Protocol", value);
		}


		/** 
		Set the value of the ReplaceKeyPrefixWith input for this Choreo. 

		@param String - (optional, string) The object key prefix to use in the redirect request. Redirects requests to the specified prefix. Cannot be used with ReplaceKeyWith. Ex.: /documents.
		*/
		public void set_ReplaceKeyPrefixWith(String value) {
			this.setInput("ReplaceKeyPrefixWith", value);
		}


		/** 
		Set the value of the ReplaceKeyWith input for this Choreo. 

		@param String - (optional, string) The specific object key to use in the redirect request. Cannot be used with ReplaceKeyPrefixWith. Ex.: error.html.
		*/
		public void set_ReplaceKeyWith(String value) {
			this.setInput("ReplaceKeyWith", value);
		}


		/** 
		Set the value of the Suffix input for this Choreo. 

		@param String - (optional, string) The default page returned when there is a request to a directory. I.e.: if you input index.html, a request for /images/ will return the data for the object '/images/index.html'. Default is index.html.
		*/
		public void set_Suffix(String value) {
			this.setInput("Suffix", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PutBucketWebsiteRedirect Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutBucketWebsiteRedirectResultSet extends ResultSet {
		public PutBucketWebsiteRedirectResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Stores the response from Amazon. Note that for a successful website configuration request, no content is returned and this output variable will be empty.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
