package com.temboo.Library.Amazon.Marketplace.Reports;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetReportCount

Retrieves the number of your available Amazon Marketplace reports, ready for download, that were generated in the last 90 days.
*/
public class GetReportCount extends Choreography {

	/**
	Create a new instance of the GetReportCount Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetReportCount(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/Marketplace/Reports/GetReportCount"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetReportCountInputSet
	*/
	public GetReportCountInputSet newInputSet() {
		return new GetReportCountInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetReportCountResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetReportCountResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetReportCount
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetReportCountInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSMarketplaceId input for this Choreo. 

		@param String - (required, string) The Marketplace ID provided by Amazon Web Services.
		*/
		public void set_AWSMarketplaceId(String value) {
			this.setInput("AWSMarketplaceId", value);
		}


		/** 
		Set the value of the AWSMerchantId input for this Choreo. 

		@param String - (required, string) The Merchant ID provided by Amazon Web Services.
		*/
		public void set_AWSMerchantId(String value) {
			this.setInput("AWSMerchantId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the Acknowledged input for this Choreo. 

		@param Boolean - (optional, boolean) A Boolean value that indicates if an order report has been acknowledged by a prior call to UpdateReportAcknowledgements. Set to "true" to list order reports that have been acknowledged.
		*/
		public void set_Acknowledged(Boolean value) {
			this.setInput("Acknowledged", value);
		}

		/** 
		Set the value of the Acknowledged input for this Choreo as a String. 

		@param String - (optional, boolean) A Boolean value that indicates if an order report has been acknowledged by a prior call to UpdateReportAcknowledgements. Set to "true" to list order reports that have been acknowledged.
		*/
		public void set_Acknowledged(String value) {
			this.setInput("Acknowledged", value);	
		}
		/** 
		Set the value of the AvailableFromDate input for this Choreo. 

		@param String - (optional, date) The earliest date you are looking for, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_AvailableFromDate(String value) {
			this.setInput("AvailableFromDate", value);
		}


		/** 
		Set the value of the AvailableToDate input for this Choreo. 

		@param String - (optional, date) The most recent date you are looking for, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_AvailableToDate(String value) {
			this.setInput("AvailableToDate", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MWSAuthToken input for this Choreo. 

		@param String - (optional, string) The Amazon MWS authorization token for the given seller and developer.
		*/
		public void set_MWSAuthToken(String value) {
			this.setInput("MWSAuthToken", value);
		}


		/** 
		Set the value of the ReportType input for this Choreo. 

		@param String - (optional, string) A ReportType enumeration value (i.e. _GET_FLAT_FILE_OPEN_LISTINGS_DATA_).
		*/
		public void set_ReportType(String value) {
			this.setInput("ReportType", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetReportCount Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetReportCountResultSet extends ResultSet {
		public GetReportCountResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Count" output from this Choreo execution

		@return String - (integer) A non-negative integer. parsed from the Amazon response, that represents the total number of reports available to download.
		*/
		public String get_Count() {
			return this.getResultString("Count");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Stores the response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
