package com.temboo.Library.Amazon.IAM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PutRolePolicy

Adds or updates a policy document associated with a specified role.
*/
public class PutRolePolicy extends Choreography {

	/**
	Create a new instance of the PutRolePolicy Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PutRolePolicy(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/IAM/PutRolePolicy"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutRolePolicyInputSet
	*/
	public PutRolePolicyInputSet newInputSet() {
		return new PutRolePolicyInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutRolePolicyResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutRolePolicyResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PutRolePolicy
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutRolePolicyInputSet extends InputSet {
		/** 
		Set the value of the PolicyDocument input for this Choreo. 

		@param String - (required, json) The policy document. See documentation for formatting examples.
		*/
		public void set_PolicyDocument(String value) {
			this.setInput("PolicyDocument", value);
		}


		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the PolicyName input for this Choreo. 

		@param String - (required, string) The name of the policy document.
		*/
		public void set_PolicyName(String value) {
			this.setInput("PolicyName", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the RoleName input for this Choreo. 

		@param String - (required, string) The name of the role to associate the policy with.
		*/
		public void set_RoleName(String value) {
			this.setInput("RoleName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PutRolePolicy Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutRolePolicyResultSet extends ResultSet {
		public PutRolePolicyResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
