package com.temboo.Library.Amazon.EC2;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RunInstances

Calls the Amazon EC2 API to launch the specified number of instances of an AMI for which you have permissions.
*/
public class RunInstances extends Choreography {

	/**
	Create a new instance of the RunInstances Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RunInstances(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/EC2/RunInstances"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RunInstancesInputSet
	*/
	public RunInstancesInputSet newInputSet() {
		return new RunInstancesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RunInstancesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RunInstancesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RunInstances
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RunInstancesInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the DeleteOnTermination input for this Choreo. 

		@param Boolean - (optional, boolean) Sets whether the volume is deleted on instance termination. Defaults to "true". This is a Block Device Mapping parameter.
		*/
		public void set_DeleteOnTermination(Boolean value) {
			this.setInput("DeleteOnTermination", value);
		}

		/** 
		Set the value of the DeleteOnTermination input for this Choreo as a String. 

		@param String - (optional, boolean) Sets whether the volume is deleted on instance termination. Defaults to "true". This is a Block Device Mapping parameter.
		*/
		public void set_DeleteOnTermination(String value) {
			this.setInput("DeleteOnTermination", value);	
		}
		/** 
		Set the value of the DeviceName input for this Choreo. 

		@param String - (optional, string) The device name exposed to the instance (i.e. /dev/sdh or xvdh). This is a Block Device Mapping parameter.
		*/
		public void set_DeviceName(String value) {
			this.setInput("DeviceName", value);
		}


		/** 
		Set the value of the ImageId input for this Choreo. 

		@param String - (required, string) The ID of the AMI.
		*/
		public void set_ImageId(String value) {
			this.setInput("ImageId", value);
		}


		/** 
		Set the value of the InstanceType input for this Choreo. 

		@param String - (optional, string) The instance type (i.e. t1.micro, m1.small, m1.medium, m1.large, m1.xlarge). Default is m1.small.
		*/
		public void set_InstanceType(String value) {
			this.setInput("InstanceType", value);
		}


		/** 
		Set the value of the Iops input for this Choreo. 

		@param Integer - (optional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000. This is a Block Device Mapping parameter.
		*/
		public void set_Iops(Integer value) {
			this.setInput("Iops", value);
		}

		/** 
		Set the value of the Iops input for this Choreo as a String. 

		@param String - (optional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000. This is a Block Device Mapping parameter.
		*/
		public void set_Iops(String value) {
			this.setInput("Iops", value);	
		}
		/** 
		Set the value of the KernelId input for this Choreo. 

		@param String - (optional, string) The ID of the kernel with which to launch the instance.
		*/
		public void set_KernelId(String value) {
			this.setInput("KernelId", value);
		}


		/** 
		Set the value of the KeyName input for this Choreo. 

		@param String - (optional, string) The name of the key pair to use.
		*/
		public void set_KeyName(String value) {
			this.setInput("KeyName", value);
		}


		/** 
		Set the value of the MaxCount input for this Choreo. 

		@param Integer - (required, integer) The maximum number of instances to launch. If the value is more than Amazon EC2 can launch, the largest possible number above MinCount will be launched instead.
		*/
		public void set_MaxCount(Integer value) {
			this.setInput("MaxCount", value);
		}

		/** 
		Set the value of the MaxCount input for this Choreo as a String. 

		@param String - (required, integer) The maximum number of instances to launch. If the value is more than Amazon EC2 can launch, the largest possible number above MinCount will be launched instead.
		*/
		public void set_MaxCount(String value) {
			this.setInput("MaxCount", value);	
		}
		/** 
		Set the value of the MinCount input for this Choreo. 

		@param Integer - (required, integer) The minimum number of instances to launch. If the value is more than Amazon EC2 can launch, no instances are launched at all.
		*/
		public void set_MinCount(Integer value) {
			this.setInput("MinCount", value);
		}

		/** 
		Set the value of the MinCount input for this Choreo as a String. 

		@param String - (required, integer) The minimum number of instances to launch. If the value is more than Amazon EC2 can launch, no instances are launched at all.
		*/
		public void set_MinCount(String value) {
			this.setInput("MinCount", value);	
		}
		/** 
		Set the value of the MonitoringEnabled input for this Choreo. 

		@param Boolean - (optional, boolean) Enables monitoring for the instance. Defaults to false.
		*/
		public void set_MonitoringEnabled(Boolean value) {
			this.setInput("MonitoringEnabled", value);
		}

		/** 
		Set the value of the MonitoringEnabled input for this Choreo as a String. 

		@param String - (optional, boolean) Enables monitoring for the instance. Defaults to false.
		*/
		public void set_MonitoringEnabled(String value) {
			this.setInput("MonitoringEnabled", value);	
		}
		/** 
		Set the value of the NoDevice input for this Choreo. 

		@param Boolean - (optional, boolean) Suppresses a device mapping. This is a Block Device Mapping parameter.
		*/
		public void set_NoDevice(Boolean value) {
			this.setInput("NoDevice", value);
		}

		/** 
		Set the value of the NoDevice input for this Choreo as a String. 

		@param String - (optional, boolean) Suppresses a device mapping. This is a Block Device Mapping parameter.
		*/
		public void set_NoDevice(String value) {
			this.setInput("NoDevice", value);	
		}
		/** 
		Set the value of the PlacementAvailabilityZone input for this Choreo. 

		@param String - (optional, string) The Availability Zone to launch the instance into.
		*/
		public void set_PlacementAvailabilityZone(String value) {
			this.setInput("PlacementAvailabilityZone", value);
		}


		/** 
		Set the value of the PlacementGroupName input for this Choreo. 

		@param String - (optional, string) The name of an existing placement group you want to launch the instance into (for cluster instances).
		*/
		public void set_PlacementGroupName(String value) {
			this.setInput("PlacementGroupName", value);
		}


		/** 
		Set the value of the PlacementTenancy input for this Choreo. 

		@param String - (optional, string) The tenancy of the instance. When set to "dedicated", the instance will run on single-tenant hardware and can only be launched into a VPC.
		*/
		public void set_PlacementTenancy(String value) {
			this.setInput("PlacementTenancy", value);
		}


		/** 
		Set the value of the RamdiskId input for this Choreo. 

		@param String - (optional, string) The ID of the RAM disk.
		*/
		public void set_RamdiskId(String value) {
			this.setInput("RamdiskId", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SecurityGroup input for this Choreo. 

		@param String - (optional, string) One or more security group names. This can be a comma-separated list of up to 10 security group names.
		*/
		public void set_SecurityGroup(String value) {
			this.setInput("SecurityGroup", value);
		}


		/** 
		Set the value of the SecurityGroupId input for this Choreo. 

		@param String - (optional, string) One or more security group IDs. This can be a comma-separated list of up to 10 security group ids.
		*/
		public void set_SecurityGroupId(String value) {
			this.setInput("SecurityGroupId", value);
		}


		/** 
		Set the value of the ShutdownBehavior input for this Choreo. 

		@param String - (optional, string) Whether the instance stops or terminates on instance-initiated shutdown. Valid values are: stop and terminate.
		*/
		public void set_ShutdownBehavior(String value) {
			this.setInput("ShutdownBehavior", value);
		}


		/** 
		Set the value of the SnapshotId input for this Choreo. 

		@param String - (optional, string) The ID of the snapshot. This is a Block Device Mapping parameter.
		*/
		public void set_SnapshotId(String value) {
			this.setInput("SnapshotId", value);
		}


		/** 
		Set the value of the SubnetId input for this Choreo. 

		@param String - (optional, string) The ID of the subnet to launch the instance into (i.e. subnet-dea63cb7).
		*/
		public void set_SubnetId(String value) {
			this.setInput("SubnetId", value);
		}


		/** 
		Set the value of the UserData input for this Choreo. 

		@param String - (optional, string) The Base64-encoded MIME user data to be made available to the instance(s).
		*/
		public void set_UserData(String value) {
			this.setInput("UserData", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


		/** 
		Set the value of the VirtualName input for this Choreo. 

		@param String - (optional, string) The name of the virtual device. This is a Block Device Mapping parameter.
		*/
		public void set_VirtualName(String value) {
			this.setInput("VirtualName", value);
		}


		/** 
		Set the value of the VolumeSize input for this Choreo. 

		@param String - (optional, string) The size of the volume, in GiBs. Required unless you're creating the volume from a snapshot which indicates that the size will be the size of the snapshot. This is a Block Device Mapping parameter.
		*/
		public void set_VolumeSize(String value) {
			this.setInput("VolumeSize", value);
		}


		/** 
		Set the value of the VolumeType input for this Choreo. 

		@param String - (optional, string) The volume type. Valid values are: standard (the default) and io1. This is a Block Device Mapping parameter.
		*/
		public void set_VolumeType(String value) {
			this.setInput("VolumeType", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RunInstances Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RunInstancesResultSet extends ResultSet {
		public RunInstancesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
