package com.temboo.Library.Amazon.CloudDrive.Trash;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListTrash

Queries the Amazon Cloud Drive API to return metadata for items in the trash.
*/
public class ListTrash extends Choreography {

	/**
	Create a new instance of the ListTrash Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListTrash(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/CloudDrive/Trash/ListTrash"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListTrashInputSet
	*/
	public ListTrashInputSet newInputSet() {
		return new ListTrashInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListTrashResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListTrashResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListTrash
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListTrashInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma-separated list of additional fields to include in the response.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the Filters input for this Choreo. 

		@param String - (optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".
		*/
		public void set_Filters(String value) {
			this.setInput("Filters", value);
		}


		/** 
		Set the value of the HandleRequestThrottling input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
		*/
		public void set_HandleRequestThrottling(Boolean value) {
			this.setInput("HandleRequestThrottling", value);
		}

		/** 
		Set the value of the HandleRequestThrottling input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
		*/
		public void set_HandleRequestThrottling(String value) {
			this.setInput("HandleRequestThrottling", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param String - (optional, string) The maximum number of records to be returned.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);
		}


		/** 
		Set the value of the MetaDataURL input for this Choreo. 

		@param String - (optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
		*/
		public void set_MetaDataURL(String value) {
			this.setInput("MetaDataURL", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the StartToken input for this Choreo. 

		@param String - (optional, string) The nextToken returned from a previous request. Used to paginate through results.
		*/
		public void set_StartToken(String value) {
			this.setInput("StartToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListTrash Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListTrashResultSet extends ResultSet {
		public ListTrashResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
