package com.temboo.Library.CloudMine.UserAccountManagement;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PasswordChange

Updates a user's password.
*/
public class PasswordChange extends Choreography {

	/**
	Create a new instance of the PasswordChange Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PasswordChange(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CloudMine/UserAccountManagement/PasswordChange"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PasswordChangeInputSet
	*/
	public PasswordChangeInputSet newInputSet() {
		return new PasswordChangeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PasswordChangeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PasswordChangeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PasswordChange
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PasswordChangeInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by CloudMine after registering your app.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ApplicationIdentifier input for this Choreo. 

		@param String - (required, string) The application identifier provided by CloudMine after registering your app.
		*/
		public void set_ApplicationIdentifier(String value) {
			this.setInput("ApplicationIdentifier", value);
		}


		/** 
		Set the value of the NewPassword input for this Choreo. 

		@param String - (required, string) The user's new password.
		*/
		public void set_NewPassword(String value) {
			this.setInput("NewPassword", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, string) The password for the user that needs to authenticate.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The username for the user that needs to authenticate.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PasswordChange Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PasswordChangeResultSet extends ResultSet {
		public PasswordChangeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from CloudMine.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
