package com.temboo.Library.Facebook.Searching;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Search

Search public objects across the social graph.
*/
public class Search extends Choreography {

	/**
	Create a new instance of the Search Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Search(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Searching/Search"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchInputSet
	*/
	public SearchInputSet newInputSet() {
		return new SearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Search
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (conditional, string) The access token retrieved from the final OAuth step.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Center input for this Choreo. 

		@param String - (conditional, string) The coordinates for a place (such as 37.76,122.427). Used only when specifying an object type of "place".
		*/
		public void set_Center(String value) {
			this.setInput("Center", value);
		}


		/** 
		Set the value of the Distance input for this Choreo. 

		@param Integer - (optional, integer) The distance search parameter used only when specifying an object type of "place". Defaults to 1000.
		*/
		public void set_Distance(Integer value) {
			this.setInput("Distance", value);
		}

		/** 
		Set the value of the Distance input for this Choreo as a String. 

		@param String - (optional, integer) The distance search parameter used only when specifying an object type of "place". Defaults to 1000.
		*/
		public void set_Distance(String value) {
			this.setInput("Distance", value);	
		}
		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma separated list of fields to return (i.e. id,name).
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Used to page through results. Limits the number of records returned in the response.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Used to page through results. Limits the number of records returned in the response.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the ObjectType input for this Choreo. 

		@param String - (required, string) The type of object to search for such as: user, page, event, group, or place.
		*/
		public void set_ObjectType(String value) {
			this.setInput("ObjectType", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) Used to page through results. Returns results starting from the specified number.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) Used to page through results. Returns results starting from the specified number.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (conditional, string) The Facebook query term to send in the request.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Since input for this Choreo. 

		@param String - (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
		*/
		public void set_Since(String value) {
			this.setInput("Since", value);
		}


		/** 
		Set the value of the Until input for this Choreo. 

		@param String - (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
		*/
		public void set_Until(String value) {
			this.setInput("Until", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Search Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchResultSet extends ResultSet {
		public SearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "HasNext" output from this Choreo execution

		@return String - (boolean) A boolean flag indicating that a next page exists.
		*/
		public String get_HasNext() {
			return this.getResultString("HasNext");
		}
		/** 
		Retrieve the value for the "HasPrevious" output from this Choreo execution

		@return String - (boolean) A boolean flag indicating that a previous page exists.
		*/
		public String get_HasPrevious() {
			return this.getResultString("HasPrevious");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
