package com.temboo.Library.Facebook.Publishing;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Post

Adds an entry to a user's profile feed.
*/
public class Post extends Choreography {

	/**
	Create a new instance of the Post Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Post(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Publishing/Post"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PostInputSet
	*/
	public PostInputSet newInputSet() {
		return new PostInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PostResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PostResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Post
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PostInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Caption input for this Choreo. 

		@param String - (optional, string) Caption of the post (only used if link is specified).
		*/
		public void set_Caption(String value) {
			this.setInput("Caption", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) Description of the post (only used if link is specified).
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the Link input for this Choreo. 

		@param String - (conditional, string) Link to Post. Supply either a message or a link
		*/
		public void set_Link(String value) {
			this.setInput("Link", value);
		}


		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (required, string) The message to Post. Supply either a message or a link.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (optional, string) Name of the post (only used if link is specified).
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Picture input for this Choreo. 

		@param String - (optional, string) Post thumbnail image (only used if link is specified).
		*/
		public void set_Picture(String value) {
			this.setInput("Picture", value);
		}


		/** 
		Set the value of the PlaceID input for this Choreo. 

		@param String - (optional, string) Facebook Page ID of the location associated with this post.
		*/
		public void set_PlaceID(String value) {
			this.setInput("PlaceID", value);
		}


		/** 
		Set the value of the ProfileID input for this Choreo. 

		@param String - (optional, string) The id of the profile that is being updated. Defaults to "me" indicating the authenticated user.
		*/
		public void set_ProfileID(String value) {
			this.setInput("ProfileID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) Comma-separated list of Facebook IDs of people tagged in this Post. NOTE: You cannot specify this field without also specifying a place.
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Post Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PostResultSet extends ResultSet {
		public PostResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
