package com.temboo.Library.Utilities.TokenStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveToken

Retrieves a specified token.
*/
public class RetrieveToken extends Choreography {

	/**
	Create a new instance of the RetrieveToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/TokenStorage/RetrieveToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveTokenInputSet
	*/
	public RetrieveTokenInputSet newInputSet() {
		return new RetrieveTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveTokenInputSet extends InputSet {
		/** 
		Set the value of the LockToken input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, the Choreo will attempt to lock the token after retrieving it. If the token is already locked, the Choreo will attempt to get the lock for up-to 1 minute.
		*/
		public void set_LockToken(Boolean value) {
			this.setInput("LockToken", value);
		}

		/** 
		Set the value of the LockToken input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, the Choreo will attempt to lock the token after retrieving it. If the token is already locked, the Choreo will attempt to get the lock for up-to 1 minute.
		*/
		public void set_LockToken(String value) {
			this.setInput("LockToken", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The name of the token to retrieve.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveTokenResultSet extends ResultSet {
		public RetrieveTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Token" output from this Choreo execution

		@return String - (string) The token value. This will return an empty string if there is no token or if the token has expired.
		*/
		public String get_Token() {
			return this.getResultString("Token");
		}
		/** 
		Retrieve the value for the "Locked" output from this Choreo execution

		@return String - (boolean) Returns true or false depending on whether the token is locked or not.
		*/
		public String get_Locked() {
			return this.getResultString("Locked");
		}
		/** 
		Retrieve the value for the "Valid" output from this Choreo execution

		@return String - (boolean) Returns true or false depending on whether the token is valid or not.
		*/
		public String get_Valid() {
			return this.getResultString("Valid");
		}
	}
	
}
