package com.temboo.Library.Utilities.TokenStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTokenDetails

Returns one or more tokens represented by a specified list of names.
*/
public class GetTokenDetails extends Choreography {

	/**
	Create a new instance of the GetTokenDetails Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTokenDetails(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/TokenStorage/GetTokenDetails"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTokenDetailsInputSet
	*/
	public GetTokenDetailsInputSet newInputSet() {
		return new GetTokenDetailsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTokenDetailsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTokenDetailsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTokenDetails
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTokenDetailsInputSet extends InputSet {
		/** 
		Set the value of the Names input for this Choreo. 

		@param String - (required, json) A list of tokens to return. This should be formated as a JSON array.
		*/
		public void set_Names(String value) {
			this.setInput("Names", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTokenDetails Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTokenDetailsResultSet extends ResultSet {
		public GetTokenDetailsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Tokens" output from this Choreo execution

		@return String - (json) The token values.
		*/
		public String get_Tokens() {
			return this.getResultString("Tokens");
		}
	}
	
}
