package com.temboo.Library.Utilities.Test;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
HelloWorld

Allows you to run a simple test that outputs "Hello, world!" when executed.
*/
public class HelloWorld extends Choreography {

	/**
	Create a new instance of the HelloWorld Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public HelloWorld(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Test/HelloWorld"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return HelloWorldInputSet
	*/
	public HelloWorldInputSet newInputSet() {
		return new HelloWorldInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public HelloWorldResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new HelloWorldResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the HelloWorld
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class HelloWorldInputSet extends InputSet {
		/** 
		Set the value of the Value input for this Choreo. 

		@param String - (conditional, string) An optional test value to pass into the result message.
		*/
		public void set_Value(String value) {
			this.setInput("Value", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the HelloWorld Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class HelloWorldResultSet extends ResultSet {
		public HelloWorldResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Result" output from this Choreo execution

		@return String - (string) Contains a sample Choreo output. If no input is provided, the result will be "Hello, world!". When passing an input value, the result will be "Hello, {Value}!".
		*/
		public String get_Result() {
			return this.getResultString("Result");
		}
	}
	
}
