package com.temboo.Library.Utilities.Formatting;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RemoveWhiteSpace

Returns the specified formatted text as a compact string with no new lines, tabs, or preceding/trailing white space.
*/
public class RemoveWhiteSpace extends Choreography {

	/**
	Create a new instance of the RemoveWhiteSpace Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RemoveWhiteSpace(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Formatting/RemoveWhiteSpace"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RemoveWhiteSpaceInputSet
	*/
	public RemoveWhiteSpaceInputSet newInputSet() {
		return new RemoveWhiteSpaceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RemoveWhiteSpaceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RemoveWhiteSpaceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RemoveWhiteSpace
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RemoveWhiteSpaceInputSet extends InputSet {
		/** 
		Set the value of the FormattedText input for this Choreo. 

		@param String - (required, multiline) The formatted text that should have line breaks and tabs removed.
		*/
		public void set_FormattedText(String value) {
			this.setInput("FormattedText", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RemoveWhiteSpace Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RemoveWhiteSpaceResultSet extends ResultSet {
		public RemoveWhiteSpaceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CompactText" output from this Choreo execution

		@return String - (string) 
		*/
		public String get_CompactText() {
			return this.getResultString("CompactText");
		}
	}
	
}
