package com.temboo.Library.Utilities.DataConversions;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
XMLToCSV

Converts an XML file to CSV format.
*/
public class XMLToCSV extends Choreography {

	/**
	Create a new instance of the XMLToCSV Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public XMLToCSV(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/DataConversions/XMLToCSV"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return XMLToCSVInputSet
	*/
	public XMLToCSVInputSet newInputSet() {
		return new XMLToCSVInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public XMLToCSVResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new XMLToCSVResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the XMLToCSV
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class XMLToCSVInputSet extends InputSet {
		/** 
		Set the value of the XML input for this Choreo. 

		@param String - (required, xml) The XML file to convert to CSV data.
		*/
		public void set_XML(String value) {
			this.setInput("XML", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (optional, string) If your XML is not in "/rowset/row/column_name" format, specify a path to the rows. See documentation for examples.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the XMLToCSV Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class XMLToCSVResultSet extends ResultSet {
		public XMLToCSVResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CSV" output from this Choreo execution

		@return String - (multiline) The CSV data generated from the XML input.
		*/
		public String get_CSV() {
			return this.getResultString("CSV");
		}
	}
	
}
