package com.temboo.Library.Mixpanel.DataExport.Events;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TopNames

Gets a list of the most common events over the last 31 days.
*/
public class TopNames extends Choreography {

	/**
	Create a new instance of the TopNames Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TopNames(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Mixpanel/DataExport/Events/TopNames"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TopNamesInputSet
	*/
	public TopNamesInputSet newInputSet() {
		return new TopNamesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TopNamesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TopNamesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TopNames
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TopNamesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Expire input for this Choreo. 

		@param Integer - (optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.
		*/
		public void set_Expire(Integer value) {
			this.setInput("Expire", value);
		}

		/** 
		Set the value of the Expire input for this Choreo as a String. 

		@param String - (optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.
		*/
		public void set_Expire(String value) {
			this.setInput("Expire", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of events to return. Defaults to 100 (the max the limit).
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of events to return. Defaults to 100 (the max the limit).
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (required, string) The analysis type you would like to get data for. Valid values are: general, unique, or average
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TopNames Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TopNamesResultSet extends ResultSet {
		public TopNamesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Mixpanel.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
