package com.temboo.Library.Zoho.CRM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetRecords

Retrieves all users data specified in the API request.
*/
public class GetRecords extends Choreography {

	/**
	Create a new instance of the GetRecords Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetRecords(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zoho/CRM/GetRecords"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetRecordsInputSet
	*/
	public GetRecordsInputSet newInputSet() {
		return new GetRecordsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetRecordsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetRecordsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetRecords
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetRecordsInputSet extends InputSet {
		/** 
		Set the value of the AuthenticationToken input for this Choreo. 

		@param String - (required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.
		*/
		public void set_AuthenticationToken(String value) {
			this.setInput("AuthenticationToken", value);
		}


		/** 
		Set the value of the FromIndex input for this Choreo. 

		@param Integer - (optional, integer) The beginning index of the result set to return. Defaults to 1.
		*/
		public void set_FromIndex(Integer value) {
			this.setInput("FromIndex", value);
		}

		/** 
		Set the value of the FromIndex input for this Choreo as a String. 

		@param String - (optional, integer) The beginning index of the result set to return. Defaults to 1.
		*/
		public void set_FromIndex(String value) {
			this.setInput("FromIndex", value);	
		}
		/** 
		Set the value of the LastModifiedTime input for this Choreo. 

		@param String - (optional, date) Used to return records with a created or modified date that is after the specified time.  (i.e. 2010-04-21 11:09:23)
		*/
		public void set_LastModifiedTime(String value) {
			this.setInput("LastModifiedTime", value);
		}


		/** 
		Set the value of the Module input for this Choreo. 

		@param String - (optional, string) The Zoho module you want to access. Defaults to 'Leads'.
		*/
		public void set_Module(String value) {
			this.setInput("Module", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid formats are: json and xml (the default).
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SelectColumns input for this Choreo. 

		@param String - (optional, string) The columns to return separated by commas (i.e. First Name,Last Name,Email). When left empty, only IDs are returned.
		*/
		public void set_SelectColumns(String value) {
			this.setInput("SelectColumns", value);
		}


		/** 
		Set the value of the SortColumnString input for this Choreo. 

		@param String - (optional, string) Used to specify a column to sort by (in ascending order)
		*/
		public void set_SortColumnString(String value) {
			this.setInput("SortColumnString", value);
		}


		/** 
		Set the value of the SortOrderString input for this Choreo. 

		@param String - (optional, string) Sorting order: asc or desc. Default sort order is set to ascending.
		*/
		public void set_SortOrderString(String value) {
			this.setInput("SortOrderString", value);
		}


		/** 
		Set the value of the ToIndex input for this Choreo. 

		@param Integer - (optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.
		*/
		public void set_ToIndex(Integer value) {
			this.setInput("ToIndex", value);
		}

		/** 
		Set the value of the ToIndex input for this Choreo as a String. 

		@param String - (optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.
		*/
		public void set_ToIndex(String value) {
			this.setInput("ToIndex", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetRecords Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetRecordsResultSet extends ResultSet {
		public GetRecordsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
