package com.temboo.Library.Zendesk.Tickets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateTicket

Updates an existing ticket.
*/
public class UpdateTicket extends Choreography {

	/**
	Create a new instance of the UpdateTicket Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateTicket(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Tickets/UpdateTicket"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateTicketInputSet
	*/
	public UpdateTicketInputSet newInputSet() {
		return new UpdateTicketInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateTicketResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateTicketResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateTicket
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateTicketInputSet extends InputSet {
		/** 
		Set the value of the Comment input for this Choreo. 

		@param String - (conditional, string) The text for a ticket comment.
		*/
		public void set_Comment(String value) {
			this.setInput("Comment", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Metadata input for this Choreo. 

		@param String - (optional, json) Ticket metadata formatted in JSON. See below for more information on the input format.
		*/
		public void set_Metadata(String value) {
			this.setInput("Metadata", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Public input for this Choreo. 

		@param Boolean - (optional, boolean) A flag indicating if this update is public or not. Defaults to "true"
		*/
		public void set_Public(Boolean value) {
			this.setInput("Public", value);
		}

		/** 
		Set the value of the Public input for this Choreo as a String. 

		@param String - (optional, boolean) A flag indicating if this update is public or not. Defaults to "true"
		*/
		public void set_Public(String value) {
			this.setInput("Public", value);	
		}
		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Status input for this Choreo. 

		@param String - (conditional, string) The status of the ticket (i.e. solved, pending, open).
		*/
		public void set_Status(String value) {
			this.setInput("Status", value);
		}


		/** 
		Set the value of the TicketData input for this Choreo. 

		@param String - (optional, json) A JSON-formatted string containing the ticket properties you wish to set. This can be used as an alternative to setting individual inputs representing ticket properties.
		*/
		public void set_TicketData(String value) {
			this.setInput("TicketData", value);
		}


		/** 
		Set the value of the TicketID input for this Choreo. 

		@param Integer - (required, integer) The id of the ticket being updated.
		*/
		public void set_TicketID(Integer value) {
			this.setInput("TicketID", value);
		}

		/** 
		Set the value of the TicketID input for this Choreo as a String. 

		@param String - (required, integer) The id of the ticket being updated.
		*/
		public void set_TicketID(String value) {
			this.setInput("TicketID", value);	
		}
		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (optional, string) The token associated with an upload to attach to this ticket. Note that tokens can be retrieved by running the UploadFile Choreo.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateTicket Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateTicketResultSet extends ResultSet {
		public UpdateTicketResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
