package com.temboo.Library.Zendesk.Attachments;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UploadAttachment

Uploads a file to be used as an attachment to a ticket.
*/
public class UploadAttachment extends Choreography {

	/**
	Create a new instance of the UploadAttachment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UploadAttachment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Attachments/UploadAttachment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UploadAttachmentInputSet
	*/
	public UploadAttachmentInputSet newInputSet() {
		return new UploadAttachmentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UploadAttachmentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UploadAttachmentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UploadAttachment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UploadAttachmentInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the ExistingToken input for this Choreo. 

		@param String - (optional, string) Allows you to pass in an existing token when uploading multiple attachments to associate with a ticket.
		*/
		public void set_ExistingToken(String value) {
			this.setInput("ExistingToken", value);
		}


		/** 
		Set the value of the FileContents input for this Choreo. 

		@param String - (required, string) The Base64 encoded file contents of the attachment you want to upload.
		*/
		public void set_FileContents(String value) {
			this.setInput("FileContents", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (required, string) The file name of the attachment.
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - The path to a vault file to upload. Can be used as an alternative to the FileContents input.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UploadAttachment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UploadAttachmentResultSet extends ResultSet {
		public UploadAttachmentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Token" output from this Choreo execution

		@return String - (string) The token returned from Zendesk for the upload. This can be passed to the ExistingToken input when associating  multiple attachments to the same upload token.
		*/
		public String get_Token() {
			return this.getResultString("Token");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
