package com.temboo.Library.Zendesk.Requests;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListOrganizationRequests

List all requests for the specified organization.
*/
public class ListOrganizationRequests extends Choreography {

	/**
	Create a new instance of the ListOrganizationRequests Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListOrganizationRequests(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Requests/ListOrganizationRequests"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListOrganizationRequestsInputSet
	*/
	public ListOrganizationRequestsInputSet newInputSet() {
		return new ListOrganizationRequestsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListOrganizationRequestsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListOrganizationRequestsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListOrganizationRequests
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListOrganizationRequestsInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the ID input for this Choreo. 

		@param String - (required, string) The ID of the organization to list requests for.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page number of the results to be returned. Used together with the PerPage parameter to paginate a large set of results.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page number of the results to be returned. Used together with the PerPage parameter to paginate a large set of results.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return per page. Maximum is 100 and default is 100.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return per page. Maximum is 100 and default is 100.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Status input for this Choreo. 

		@param String - (optional, string) Comma-seperated list of request statuses to match (e.g. hold, open, solved, ccd)
		*/
		public void set_Status(String value) {
			this.setInput("Status", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListOrganizationRequests Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListOrganizationRequestsResultSet extends ResultSet {
		public ListOrganizationRequestsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NextPage" output from this Choreo execution

		@return String - (integer) The index for the next page of results.
		*/
		public String get_NextPage() {
			return this.getResultString("NextPage");
		}
		/** 
		Retrieve the value for the "PreviousPage" output from this Choreo execution

		@return String - (integer) The index for the previous page of results.
		*/
		public String get_PreviousPage() {
			return this.getResultString("PreviousPage");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
