package com.temboo.Library.InfluenceExplorer;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TopRecipientPoliticians

Returns the top politicians to which this individual has given money.
*/
public class TopRecipientPoliticians extends Choreography {

	/**
	Create a new instance of the TopRecipientPoliticians Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TopRecipientPoliticians(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/InfluenceExplorer/TopRecipientPoliticians"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TopRecipientPoliticiansInputSet
	*/
	public TopRecipientPoliticiansInputSet newInputSet() {
		return new TopRecipientPoliticiansInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TopRecipientPoliticiansResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TopRecipientPoliticiansResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TopRecipientPoliticians
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TopRecipientPoliticiansInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API key provided by Sunlight Data Services.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the EntityID input for this Choreo. 

		@param String - (required, string) The ID for the Entity that you want to return information for. This ID can be retrieved by running the SearchByName Choreo.
		*/
		public void set_EntityID(String value) {
			this.setInput("EntityID", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of resutls to return.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of resutls to return.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TopRecipientPoliticians Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TopRecipientPoliticiansResultSet extends ResultSet {
		public TopRecipientPoliticiansResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Influence Explorer.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
