package com.temboo.Library.NYTimes.RealEstate;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetListingsCounts

Retrieves counts of real estate listings from New York Times Web Service.
*/
public class GetListingsCounts extends Choreography {

	/**
	Create a new instance of the GetListingsCounts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetListingsCounts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/RealEstate/GetListingsCounts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetListingsCountsInputSet
	*/
	public GetListingsCountsInputSet newInputSet() {
		return new GetListingsCountsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetListingsCountsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetListingsCountsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetListingsCounts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetListingsCountsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Bedrooms input for this Choreo. 

		@param Integer - (optional, integer) Limits the results by number of bedrooms to search for. Defaults to 1.
		*/
		public void set_Bedrooms(Integer value) {
			this.setInput("Bedrooms", value);
		}

		/** 
		Set the value of the Bedrooms input for this Choreo as a String. 

		@param String - (optional, integer) Limits the results by number of bedrooms to search for. Defaults to 1.
		*/
		public void set_Bedrooms(String value) {
			this.setInput("Bedrooms", value);	
		}
		/** 
		Set the value of the DateRange input for this Choreo. 

		@param String - (required, string) Sets the quarter, month, week or day for the results (i.e. 2008-Q1, 2008-W52, 2007-07, 2010-10-01, etc).
		*/
		public void set_DateRange(String value) {
			this.setInput("DateRange", value);
		}


		/** 
		Set the value of the GeoExtentLevel input for this Choreo. 

		@param String - (required, string) The geographical unit for the results (i.e. borough, neighborhood, or zip).
		*/
		public void set_GeoExtentLevel(String value) {
			this.setInput("GeoExtentLevel", value);
		}


		/** 
		Set the value of the GeoExtentValue input for this Choreo. 

		@param String - (required, string) Limits the search to a specific area.  For example, if GeoExtentLevel is borough, the value for GeoExtentValue could be Brooklyn.
		*/
		public void set_GeoExtentValue(String value) {
			this.setInput("GeoExtentValue", value);
		}


		/** 
		Set the value of the GeoSummaryLevel input for this Choreo. 

		@param String - (required, string) The geographic unit for grouping the results (borough, neighborhood, or zip).
		*/
		public void set_GeoSummaryLevel(String value) {
			this.setInput("GeoSummaryLevel", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetListingsCounts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetListingsCountsResultSet extends ResultSet {
		public GetListingsCountsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
