package com.temboo.Library.Zillow;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetRateSummary

Retrieve current interest rates for a specified loan type.
*/
public class GetRateSummary extends Choreography {

	/**
	Create a new instance of the GetRateSummary Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetRateSummary(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zillow/GetRateSummary"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetRateSummaryInputSet
	*/
	public GetRateSummaryInputSet newInputSet() {
		return new GetRateSummaryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetRateSummaryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetRateSummaryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetRateSummary
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetRateSummaryInputSet extends InputSet {
		/** 
		Set the value of the OutputFormat input for this Choreo. 

		@param String - (optional, string) Enter the desired query output format.  Enter: xml, or json.  Default output is set to: xml.
		*/
		public void set_OutputFormat(String value) {
			this.setInput("OutputFormat", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Enter a U.S. state abbreviation for which to retrieve mortgage rates.  If null, the national average rate is returned.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the ZWSID input for this Choreo. 

		@param String - (required, string) Enter a Zillow Web Service Identifier (ZWS ID).
		*/
		public void set_ZWSID(String value) {
			this.setInput("ZWSID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetRateSummary Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetRateSummaryResultSet extends ResultSet {
		public GetRateSummaryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Zillow.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
