package com.temboo.Library.Bugzilla;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveAttachment

Retrieves a bug attachment by ID.
*/
public class RetrieveAttachment extends Choreography {

	/**
	Create a new instance of the RetrieveAttachment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveAttachment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Bugzilla/RetrieveAttachment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveAttachmentInputSet
	*/
	public RetrieveAttachmentInputSet newInputSet() {
		return new RetrieveAttachmentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveAttachmentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveAttachmentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveAttachment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveAttachmentInputSet extends InputSet {
		/** 
		Set the value of the AttachmentID input for this Choreo. 

		@param Integer - (required, integer) The ID of the attachment to retrieve.
		*/
		public void set_AttachmentID(Integer value) {
			this.setInput("AttachmentID", value);
		}

		/** 
		Set the value of the AttachmentID input for this Choreo as a String. 

		@param String - (required, integer) The ID of the attachment to retrieve.
		*/
		public void set_AttachmentID(String value) {
			this.setInput("AttachmentID", value);	
		}
		/** 
		Set the value of the AttachmentsWithData input for this Choreo. 

		@param Integer - (optional, integer) Enter 1 to obtain full bug attachments data.  If null, only attachments fields will be returned with no associated data.
		*/
		public void set_AttachmentsWithData(Integer value) {
			this.setInput("AttachmentsWithData", value);
		}

		/** 
		Set the value of the AttachmentsWithData input for this Choreo as a String. 

		@param String - (optional, integer) Enter 1 to obtain full bug attachments data.  If null, only attachments fields will be returned with no associated data.
		*/
		public void set_AttachmentsWithData(String value) {
			this.setInput("AttachmentsWithData", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) Your Bugzilla password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (optional, string) The base URL for the Bugzilla server to access. Defaults to https://api-dev.bugzilla.mozilla.org/latest. To access the test server, set to https://api-dev.bugzilla.mozilla.org/test/latest.
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) Your Bugzilla username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveAttachment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveAttachmentResultSet extends ResultSet {
		public RetrieveAttachmentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Bugzilla.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
