package com.temboo.Library.Google.Sheets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateValues

Updates values in the specified range of a spreadsheet.
*/
public class UpdateValues extends Choreography {

	/**
	Create a new instance of the UpdateValues Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateValues(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Sheets/UpdateValues"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateValuesInputSet
	*/
	public UpdateValuesInputSet newInputSet() {
		return new UpdateValuesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateValuesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateValuesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateValues
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateValuesInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the MajorDimension input for this Choreo. 

		@param String - (optional, string) Indicates the dimension that the values array applies to. Valid values are ROWS (the default) or COLUMNS.
		*/
		public void set_MajorDimension(String value) {
			this.setInput("MajorDimension", value);
		}


		/** 
		Set the value of the Range input for this Choreo. 

		@param String - (required, string) The A1 notation of a range to update. See Choreos notes for more details.
		*/
		public void set_Range(String value) {
			this.setInput("Range", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the SpreadsheetID input for this Choreo. 

		@param String - (required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.
		*/
		public void set_SpreadsheetID(String value) {
			this.setInput("SpreadsheetID", value);
		}


		/** 
		Set the value of the ValueInputOption input for this Choreo. 

		@param String - (optional, string) Specifies how the input data should be interpreted. Valid values are: RAW (the default) and USER_ENTERED.
		*/
		public void set_ValueInputOption(String value) {
			this.setInput("ValueInputOption", value);
		}


		/** 
		Set the value of the Values input for this Choreo. 

		@param String - (required, json) This is an array of arrays. The outer array can represent one or more rows while the inner array can represent one or more cell values. See Choreo notes below for more details.
		*/
		public void set_Values(String value) {
			this.setInput("Values", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateValues Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateValuesResultSet extends ResultSet {
		public UpdateValuesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
