package com.temboo.Library.Google.Places;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UserPlaceReports

Add a new Place to Google Places.
*/
public class UserPlaceReports extends Choreography {

	/**
	Create a new instance of the UserPlaceReports Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UserPlaceReports(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Places/UserPlaceReports"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UserPlaceReportsInputSet
	*/
	public UserPlaceReportsInputSet newInputSet() {
		return new UserPlaceReportsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UserPlaceReportsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UserPlaceReportsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UserPlaceReports
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UserPlaceReportsInputSet extends InputSet {
		/** 
		Set the value of the POSTForm input for this Choreo. 

		@param String - (optional, json) A JSON request body containing the information about the place. This can be specified as an alternative to specifying individual place properties. See Choreo notes for details about formatting.
		*/
		public void set_POSTForm(String value) {
			this.setInput("POSTForm", value);
		}


		/** 
		Set the value of the Accuracy input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The accuracy of the location signal on which this request is based, expressed in meters.
		*/
		public void set_Accuracy(BigDecimal value) {
			this.setInput("Accuracy", value);
		}

		/** 
		Set the value of the Accuracy input for this Choreo as a String. 

		@param String - (conditional, decimal) The accuracy of the location signal on which this request is based, expressed in meters.
		*/
		public void set_Accuracy(String value) {
			this.setInput("Accuracy", value);	
		}
		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (optional, string) The address of the place you wish to add.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the Key input for this Choreo. 

		@param String - (required, string) The API Key provided by Google.
		*/
		public void set_Key(String value) {
			this.setInput("Key", value);
		}


		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (conditional, string) The language in which the place's name is being reported.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude point for the place you wish to add (e.g., 38.898717).
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude point for the place you wish to add (e.g., 38.898717).
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude coordinate for the place you wish to add (e.g., -77.035974).
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude coordinate for the place you wish to add (e.g., -77.035974).
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The full text name of the place
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the PhoneNumber input for this Choreo. 

		@param String - (optional, string) The phone number associated with the place.
		*/
		public void set_PhoneNumber(String value) {
			this.setInput("PhoneNumber", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sensor input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(Boolean value) {
			this.setInput("Sensor", value);
		}

		/** 
		Set the value of the Sensor input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(String value) {
			this.setInput("Sensor", value);	
		}
		/** 
		Set the value of the Types input for this Choreo. 

		@param String - (required, json) A JSON array of categories in which this place belongs.
		*/
		public void set_Types(String value) {
			this.setInput("Types", value);
		}


		/** 
		Set the value of the Website input for this Choreo. 

		@param String - (optional, string) A URL pointing to the authoritative website for this Place, such as a business home page.
		*/
		public void set_Website(String value) {
			this.setInput("Website", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UserPlaceReports Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UserPlaceReportsResultSet extends ResultSet {
		public UserPlaceReportsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
