package com.temboo.Library.Google.Calendar;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchCalendarsByName

Retrieves information about a calendar including the id with a given calendar name.
*/
public class SearchCalendarsByName extends Choreography {

	/**
	Create a new instance of the SearchCalendarsByName Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchCalendarsByName(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Calendar/SearchCalendarsByName"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchCalendarsByNameInputSet
	*/
	public SearchCalendarsByNameInputSet newInputSet() {
		return new SearchCalendarsByNameInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchCalendarsByNameResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchCalendarsByNameResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchCalendarsByName
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchCalendarsByNameInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the CalendarName input for this Choreo. 

		@param String - (required, string) The name of the calendar that you want to retrieve information for. Note that if there are multiple calendars with the same name, only the first one will be returned.
		*/
		public void set_CalendarName(String value) {
			this.setInput("CalendarName", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Count input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of calendars to search by name. The default is 15.
		*/
		public void set_Count(Integer value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of calendars to search by name. The default is 15.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchCalendarsByName Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchCalendarsByNameResultSet extends ResultSet {
		public SearchCalendarsByNameResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CalendarDescription" output from this Choreo execution

		@return String - (string) The calendar description parsed from the Google response.
		*/
		public String get_CalendarDescription() {
			return this.getResultString("CalendarDescription");
		}
		/** 
		Retrieve the value for the "CalendarId" output from this Choreo execution

		@return String - (string) The calendar id parsed from the Google response.
		*/
		public String get_CalendarId() {
			return this.getResultString("CalendarId");
		}
		/** 
		Retrieve the value for the "CalendarSummary" output from this Choreo execution

		@return String - (string) The summary or calendar name parsed from the Google response.
		*/
		public String get_CalendarSummary() {
			return this.getResultString("CalendarSummary");
		}
		/** 
		Retrieve the value for the "CalendarTimezone" output from this Choreo execution

		@return String - (string) The calendar timezone parsed from the Google response.
		*/
		public String get_CalendarTimezone() {
			return this.getResultString("CalendarTimezone");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
	}
	
}
