package com.temboo.Library.NPR.StoryFinder;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetListByID

Retrieves a list of NPR categories from a specified list type ID.
*/
public class GetListByID extends Choreography {

	/**
	Create a new instance of the GetListByID Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetListByID(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NPR/StoryFinder/GetListByID"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetListByIDInputSet
	*/
	public GetListByIDInputSet newInputSet() {
		return new GetListByIDInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetListByIDResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetListByIDResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetListByID
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetListByIDInputSet extends InputSet {
		/** 
		Set the value of the ChildrenOf input for this Choreo. 

		@param Integer - (optional, integer) Returns only items which are assigned to the given topic ID. For example, if Id=3006 and ChildrenOf=1008 only recent series which are assigned to "Arts & Life" are returned.
		*/
		public void set_ChildrenOf(Integer value) {
			this.setInput("ChildrenOf", value);
		}

		/** 
		Set the value of the ChildrenOf input for this Choreo as a String. 

		@param String - (optional, integer) Returns only items which are assigned to the given topic ID. For example, if Id=3006 and ChildrenOf=1008 only recent series which are assigned to "Arts & Life" are returned.
		*/
		public void set_ChildrenOf(String value) {
			this.setInput("ChildrenOf", value);	
		}
		/** 
		Set the value of the HideChildren input for this Choreo. 

		@param Boolean - (optional, boolean) If set to "1", returns only topics which are not subtopics of another topic.
		*/
		public void set_HideChildren(Boolean value) {
			this.setInput("HideChildren", value);
		}

		/** 
		Set the value of the HideChildren input for this Choreo as a String. 

		@param String - (optional, boolean) If set to "1", returns only topics which are not subtopics of another topic.
		*/
		public void set_HideChildren(String value) {
			this.setInput("HideChildren", value);	
		}
		/** 
		Set the value of the Id input for this Choreo. 

		@param Integer - (required, integer) The id of the list type you want to retrieve. For example, the list type id for Music Genres is 3218).
		*/
		public void set_Id(Integer value) {
			this.setInput("Id", value);
		}

		/** 
		Set the value of the Id input for this Choreo as a String. 

		@param String - (required, integer) The id of the list type you want to retrieve. For example, the list type id for Music Genres is 3218).
		*/
		public void set_Id(String value) {
			this.setInput("Id", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are xml (the default), and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the StoryCountAll input for this Choreo. 

		@param Integer - (optional, integer) Returns only items with at least this number of associated stories.
		*/
		public void set_StoryCountAll(Integer value) {
			this.setInput("StoryCountAll", value);
		}

		/** 
		Set the value of the StoryCountAll input for this Choreo as a String. 

		@param String - (optional, integer) Returns only items with at least this number of associated stories.
		*/
		public void set_StoryCountAll(String value) {
			this.setInput("StoryCountAll", value);	
		}
		/** 
		Set the value of the StoryCountMonth input for this Choreo. 

		@param Integer - (optional, integer) Returns only items with at least this number of associated stories published in the last month.
		*/
		public void set_StoryCountMonth(Integer value) {
			this.setInput("StoryCountMonth", value);
		}

		/** 
		Set the value of the StoryCountMonth input for this Choreo as a String. 

		@param String - (optional, integer) Returns only items with at least this number of associated stories published in the last month.
		*/
		public void set_StoryCountMonth(String value) {
			this.setInput("StoryCountMonth", value);	
		}
		/** 
		Set the value of the StoryCountToday input for this Choreo. 

		@param Integer - (optional, integer) Returns only items with at least this number of associated stories published today.
		*/
		public void set_StoryCountToday(Integer value) {
			this.setInput("StoryCountToday", value);
		}

		/** 
		Set the value of the StoryCountToday input for this Choreo as a String. 

		@param String - (optional, integer) Returns only items with at least this number of associated stories published today.
		*/
		public void set_StoryCountToday(String value) {
			this.setInput("StoryCountToday", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetListByID Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetListByIDResultSet extends ResultSet {
		public GetListByIDResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from NPR.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
