package com.temboo.Library.Xively.Triggers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateTrigger

Updates an existing trigger.
*/
public class UpdateTrigger extends Choreography {

	/**
	Create a new instance of the UpdateTrigger Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateTrigger(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/Triggers/UpdateTrigger"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateTriggerInputSet
	*/
	public UpdateTriggerInputSet newInputSet() {
		return new UpdateTriggerInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateTriggerResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateTriggerResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateTrigger
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateTriggerInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ThresholdValue input for this Choreo. 

		@param String - (optional, string) Threshold that will cause the trigger to activate. Include input only if changing Threshold Value.
		*/
		public void set_ThresholdValue(String value) {
			this.setInput("ThresholdValue", value);
		}


		/** 
		Set the value of the TriggerID input for this Choreo. 

		@param Integer - (required, integer) TriggerID for the trigger that you wish to update.
		*/
		public void set_TriggerID(Integer value) {
			this.setInput("TriggerID", value);
		}

		/** 
		Set the value of the TriggerID input for this Choreo as a String. 

		@param String - (required, integer) TriggerID for the trigger that you wish to update.
		*/
		public void set_TriggerID(String value) {
			this.setInput("TriggerID", value);	
		}
		/** 
		Set the value of the TriggerType input for this Choreo. 

		@param String - (optional, string) Type of trigger. Include input only if changing TriggerType. Valid values: gt, gte, lt, lte, eq, change (any change), frozen (no updates for 15 minutes), or live (updated again after being frozen).
		*/
		public void set_TriggerType(String value) {
			this.setInput("TriggerType", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (optional, string) The URL that the Xively trigger will post to when activated. Include input only if changing the URL. Ex: http://requestb.in
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateTrigger Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateTriggerResultSet extends ResultSet {
		public UpdateTriggerResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Xively. For a successful trigger update, the code should be 200.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
	}
	
}
