package com.temboo.Library.Xively.ReadWriteData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
WriteFeedMetadata

Allows you to easily update the metadata of your feed.
*/
public class WriteFeedMetadata extends Choreography {

	/**
	Create a new instance of the WriteFeedMetadata Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public WriteFeedMetadata(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/ReadWriteData/WriteFeedMetadata"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return WriteFeedMetadataInputSet
	*/
	public WriteFeedMetadataInputSet newInputSet() {
		return new WriteFeedMetadataInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public WriteFeedMetadataResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new WriteFeedMetadataResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the WriteFeedMetadata
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class WriteFeedMetadataInputSet extends InputSet {
		/** 
		Set the value of the FeedData input for this Choreo. 

		@param String - (optional, any) Custom data body for the new feed in JSON or XML format (set by FeedType). See documentation for how to write your own feed. If custom FeedData is used, all other optional inputs are ignored.
		*/
		public void set_FeedData(String value) {
			this.setInput("FeedData", value);
		}


		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) A description of the feed. Leave empty to keep existing Description. Type "BLANK" to clear existing Description.
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (optional, string) Contact Email. Leave empty to keep existing Email. Type "BLANK" to clear existing Email.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the FeedID input for this Choreo. 

		@param Integer - (required, integer) The ID for the feed that you would like to update.
		*/
		public void set_FeedID(Integer value) {
			this.setInput("FeedID", value);
		}

		/** 
		Set the value of the FeedID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the feed that you would like to update.
		*/
		public void set_FeedID(String value) {
			this.setInput("FeedID", value);	
		}
		/** 
		Set the value of the FeedType input for this Choreo. 

		@param String - (optional, string) The type of feed that is being provided for custom FeedData. Valid values are "json" (the default) and "xml".
		*/
		public void set_FeedType(String value) {
			this.setInput("FeedType", value);
		}


		/** 
		Set the value of the Icon input for this Choreo. 

		@param String - (optional, string) The URL of an icon which is relevant to this feed. Leave empty to keep existing Icon. Type "BLANK" to clear existing Icon.
		*/
		public void set_Icon(String value) {
			this.setInput("Icon", value);
		}


		/** 
		Set the value of the Private input for this Choreo. 

		@param Boolean - (optional, boolean) Specifies whether or not the feed is private to the creator of the feed. If 'true' the feed is private, if 'false' the feed is public. Leave empty to keep existing settings.
		*/
		public void set_Private(Boolean value) {
			this.setInput("Private", value);
		}

		/** 
		Set the value of the Private input for this Choreo as a String. 

		@param String - (optional, boolean) Specifies whether or not the feed is private to the creator of the feed. If 'true' the feed is private, if 'false' the feed is public. Leave empty to keep existing settings.
		*/
		public void set_Private(String value) {
			this.setInput("Private", value);	
		}
		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) Comma-separated list of searchable tags (the characters ', ", and commas are not allowed). Tags input overwrites previous tags, enter "BLANK" to clear all tags. Ex: "power,energy".
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (optional, string) A descriptive name for the feed. Leave empty to keep existing Title. Type "BLANK" to clear existing Title.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the Website input for this Choreo. 

		@param String - (optional, string) The URL of a website which is relevant to this feed. Leave empty to keep existing Website. Type "BLANK" to clear existing Website. Ex.: http://www.homepage.com.
		*/
		public void set_Website(String value) {
			this.setInput("Website", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the WriteFeedMetadata Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class WriteFeedMetadataResultSet extends ResultSet {
		public WriteFeedMetadataResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Xively. For a successful feed update, the code should be 200.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
	}
	
}
