package com.temboo.Library.Nexmo.Account;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetNumbers

Get all inbound numbers associated with your Nexmo account.
*/
public class GetNumbers extends Choreography {

	/**
	Create a new instance of the GetNumbers Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetNumbers(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Nexmo/Account/GetNumbers"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetNumbersInputSet
	*/
	public GetNumbersInputSet newInputSet() {
		return new GetNumbersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetNumbersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetNumbersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetNumbers
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetNumbersInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your API Key provided to you by Nexmo.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) Your API Secret provided to you by Nexmo.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Index input for this Choreo. 

		@param Integer - (optional, integer) Page index.
		*/
		public void set_Index(Integer value) {
			this.setInput("Index", value);
		}

		/** 
		Set the value of the Index input for this Choreo as a String. 

		@param String - (optional, integer) Page index.
		*/
		public void set_Index(String value) {
			this.setInput("Index", value);	
		}
		/** 
		Set the value of the Pattern input for this Choreo. 

		@param String - (optional, string) Pattern to match.
		*/
		public void set_Pattern(String value) {
			this.setInput("Pattern", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "json" (the default) and "xml".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Size input for this Choreo. 

		@param Integer - (optional, integer) Page size.
		*/
		public void set_Size(Integer value) {
			this.setInput("Size", value);
		}

		/** 
		Set the value of the Size input for this Choreo as a String. 

		@param String - (optional, integer) Page size.
		*/
		public void set_Size(String value) {
			this.setInput("Size", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetNumbers Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetNumbersResultSet extends ResultSet {
		public GetNumbersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Nexmo. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
