package com.temboo.Library.Instagram;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetRecentMediaForLocation

Retrieves a list of recent media objects from a given location.
*/
public class GetRecentMediaForLocation extends Choreography {

	/**
	Create a new instance of the GetRecentMediaForLocation Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetRecentMediaForLocation(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Instagram/GetRecentMediaForLocation"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetRecentMediaForLocationInputSet
	*/
	public GetRecentMediaForLocationInputSet newInputSet() {
		return new GetRecentMediaForLocationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetRecentMediaForLocationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetRecentMediaForLocationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetRecentMediaForLocation
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetRecentMediaForLocationInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (conditional, string) The access token retrieved during the OAuth 2.0 process. Required unless you provide the ClientID.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Instagram after registering your application. Required unless you provide an AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the LocationID input for this Choreo. 

		@param Integer - (required, integer) The ID for the location that you want to retrieve information for.
		*/
		public void set_LocationID(Integer value) {
			this.setInput("LocationID", value);
		}

		/** 
		Set the value of the LocationID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the location that you want to retrieve information for.
		*/
		public void set_LocationID(String value) {
			this.setInput("LocationID", value);	
		}
		/** 
		Set the value of the MaxID input for this Choreo. 

		@param String - (optional, string) Returns media after this max_id.
		*/
		public void set_MaxID(String value) {
			this.setInput("MaxID", value);
		}


		/** 
		Set the value of the MaxTimestamp input for this Choreo. 

		@param String - (optional, date) Returns media before this UNIX timestamp.
		*/
		public void set_MaxTimestamp(String value) {
			this.setInput("MaxTimestamp", value);
		}


		/** 
		Set the value of the MinID input for this Choreo. 

		@param String - (optional, string) Returns media before this min_id.
		*/
		public void set_MinID(String value) {
			this.setInput("MinID", value);
		}


		/** 
		Set the value of the MinTimestamp input for this Choreo. 

		@param String - (optional, date) Returns media after this UNIX timestamp.
		*/
		public void set_MinTimestamp(String value) {
			this.setInput("MinTimestamp", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetRecentMediaForLocation Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetRecentMediaForLocationResultSet extends ResultSet {
		public GetRecentMediaForLocationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Instagram.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
