package com.temboo.Library.PayPal.OAuth;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetAccessToken

Retrieves an Access Token from PayPal.
*/
public class GetAccessToken extends Choreography {

	/**
	Create a new instance of the GetAccessToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetAccessToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/OAuth/GetAccessToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetAccessTokenInputSet
	*/
	public GetAccessTokenInputSet newInputSet() {
		return new GetAccessTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetAccessTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetAccessTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetAccessToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetAccessTokenInputSet extends InputSet {
		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (required, string) The Client ID provided by PayPal.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (required, string) The Client Secret provided by PayPal.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Scope input for this Choreo. 

		@param String - (optional, string) A space delimited list of resource URL endpoints that the token should have access for (i.e. https://api.paypal.com/v1/payments/.*).
		*/
		public void set_Scope(String value) {
			this.setInput("Scope", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Defaults to 0.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Defaults to 0.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetAccessToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetAccessTokenResultSet extends ResultSet {
		public GetAccessTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccessToken" output from this Choreo execution

		@return String - (string) The access token retrieved from PayPal.
		*/
		public String get_AccessToken() {
			return this.getResultString("AccessToken");
		}
		/** 
		Retrieve the value for the "Expires" output from this Choreo execution

		@return String - (integer) The expiration time of the access token retrieved.
		*/
		public String get_Expires() {
			return this.getResultString("Expires");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PayPal.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
