package com.temboo.Library.PayPal.Merchant;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddressVerify

Confirms whether a postal address and postal code match those of the specified PayPal account holder.
*/
public class AddressVerify extends Choreography {

	/**
	Create a new instance of the AddressVerify Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddressVerify(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/Merchant/AddressVerify"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddressVerifyInputSet
	*/
	public AddressVerifyInputSet newInputSet() {
		return new AddressVerifyInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddressVerifyResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddressVerifyResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddressVerify
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddressVerifyInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address of a PayPal member to verify.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The API Password provided by PayPal.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the PostalCode input for this Choreo. 

		@param String - (required, string) The postal code to verify.
		*/
		public void set_PostalCode(String value) {
			this.setInput("PostalCode", value);
		}


		/** 
		Set the value of the Signature input for this Choreo. 

		@param String - (required, string) The API Signature provided by PayPal.
		*/
		public void set_Signature(String value) {
			this.setInput("Signature", value);
		}


		/** 
		Set the value of the Street input for this Choreo. 

		@param String - (required, string) The first line of the billing or shipping address to verify.
		*/
		public void set_Street(String value) {
			this.setInput("Street", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The API Username provided by PayPal.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddressVerify Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddressVerifyResultSet extends ResultSet {
		public AddressVerifyResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) Response from PayPal formatted in name/value pairs.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
