package com.temboo.Library.GitHub.ReposAPI.Contents;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteFile

Deletes a file in a repository.
*/
public class DeleteFile extends Choreography {

	/**
	Create a new instance of the DeleteFile Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteFile(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/ReposAPI/Contents/DeleteFile"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteFileInputSet
	*/
	public DeleteFileInputSet newInputSet() {
		return new DeleteFileInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteFileResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteFileResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteFile
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteFileInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Branch input for this Choreo. 

		@param String - (optional, string) The branch name. Default: the repository’s default branch (usually master)
		*/
		public void set_Branch(String value) {
			this.setInput("Branch", value);
		}


		/** 
		Set the value of the Contributer input for this Choreo. 

		@param String - (optional, string) The type of contributer: committer (the default) or author.
		*/
		public void set_Contributer(String value) {
			this.setInput("Contributer", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (optional, string) The email of the author (or committer) of the commit.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (required, string) The commit message.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (optional, string) The name of the author (or committer) of the commit.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The content path.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the Repo input for this Choreo. 

		@param String - (required, string) The name of the repository.
		*/
		public void set_Repo(String value) {
			this.setInput("Repo", value);
		}


		/** 
		Set the value of the Sha input for this Choreo. 

		@param String - (required, string) The blob SHA of the file being deleted.
		*/
		public void set_Sha(String value) {
			this.setInput("Sha", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) The GitHub account owner.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteFile Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteFileResultSet extends ResultSet {
		public DeleteFileResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
