package com.temboo.Library.OneLogin.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateUser

Updates an existing user.
*/
public class UpdateUser extends Choreography {

	/**
	Create a new instance of the UpdateUser Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateUser(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/OneLogin/Users/UpdateUser"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateUserInputSet
	*/
	public UpdateUserInputSet newInputSet() {
		return new UpdateUserInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateUserResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateUserResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateUser
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateUserInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by OneLogin.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (conditional, string) The street address for the new account.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (conditional, string) The email address for the new user.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (conditional, string) The first name of the new user.
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the GroupID input for this Choreo. 

		@param String - (optional, string) The group id associated with the new user.
		*/
		public void set_GroupID(String value) {
			this.setInput("GroupID", value);
		}


		/** 
		Set the value of the ID input for this Choreo. 

		@param Integer - (required, integer) The id of the user you want to update.
		*/
		public void set_ID(Integer value) {
			this.setInput("ID", value);
		}

		/** 
		Set the value of the ID input for this Choreo as a String. 

		@param String - (required, integer) The id of the user you want to update.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);	
		}
		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (conditional, string) The last name of the new user.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the OpenIDName input for this Choreo. 

		@param String - (conditional, string) The open id name.
		*/
		public void set_OpenIDName(String value) {
			this.setInput("OpenIDName", value);
		}


		/** 
		Set the value of the Phone input for this Choreo. 

		@param String - (conditional, string) The phone number of the new user.
		*/
		public void set_Phone(String value) {
			this.setInput("Phone", value);
		}


		/** 
		Set the value of the Role input for this Choreo. 

		@param String - (optional, string) Updates a user's role.
		*/
		public void set_Role(String value) {
			this.setInput("Role", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateUser Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateUserResultSet extends ResultSet {
		public UpdateUserResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from OneLogin.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
