package com.temboo.Library.FedSpending;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Assistance

Allows access to the information in the Federal Assisatance Award Data System (FAADS) database, which reports all financial assistance made by federal agencies.
*/
public class Assistance extends Choreography {

	/**
	Create a new instance of the Assistance Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Assistance(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FedSpending/Assistance"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AssistanceInputSet
	*/
	public AssistanceInputSet newInputSet() {
		return new AssistanceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AssistanceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AssistanceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Assistance
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AssistanceInputSet extends InputSet {
		/** 
		Set the value of the AgencyCode input for this Choreo. 

		@param String - (conditional, string) The 4-character code for a specific governmental agency providing assistance.
		*/
		public void set_AgencyCode(String value) {
			this.setInput("AgencyCode", value);
		}


		/** 
		Set the value of the AssistanceType input for this Choreo. 

		@param String - (conditional, string) The type of assistance provided. Valid values are: d = Direct Payments (specified and unrestricted), g = Grants and Cooperative Agreements, i = Insurance, l = Loans (direct and guaranteed), o = Other.
		*/
		public void set_AssistanceType(String value) {
			this.setInput("AssistanceType", value);
		}


		/** 
		Set the value of the CFDAProgram input for this Choreo. 

		@param String - (conditional, string) An ID for the governmental program.
		*/
		public void set_CFDAProgram(String value) {
			this.setInput("CFDAProgram", value);
		}


		/** 
		Set the value of the Detail input for this Choreo. 

		@param String - (optional, string) Controls the level of detail of the output. Acceptable values: -1 (summary), 0 (low), 1 (medium), 2 (high), and 3 (extensive). Defaults to -1. See docs for more information.
		*/
		public void set_Detail(String value) {
			this.setInput("Detail", value);
		}


		/** 
		Set the value of the FederalID input for this Choreo. 

		@param String - (conditional, string) A Federal ID for the award.
		*/
		public void set_FederalID(String value) {
			this.setInput("FederalID", value);
		}


		/** 
		Set the value of the FirstYearRange input for this Choreo. 

		@param Integer - (conditional, integer) Specifies the first year in a range of years from 2000-2006; if used, must be used with LastYearRange and without FiscalYear.
		*/
		public void set_FirstYearRange(Integer value) {
			this.setInput("FirstYearRange", value);
		}

		/** 
		Set the value of the FirstYearRange input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies the first year in a range of years from 2000-2006; if used, must be used with LastYearRange and without FiscalYear.
		*/
		public void set_FirstYearRange(String value) {
			this.setInput("FirstYearRange", value);	
		}
		/** 
		Set the value of the FiscalYear input for this Choreo. 

		@param Integer - (conditional, integer) Specifies a single year from 2000-2006; defaults to all years.
		*/
		public void set_FiscalYear(Integer value) {
			this.setInput("FiscalYear", value);
		}

		/** 
		Set the value of the FiscalYear input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies a single year from 2000-2006; defaults to all years.
		*/
		public void set_FiscalYear(String value) {
			this.setInput("FiscalYear", value);	
		}
		/** 
		Set the value of the LastYearRange input for this Choreo. 

		@param Integer - (conditional, integer) Specifies the last year in a range of years from 2000-2006; if used, must be used with FirstYearRange and without FiscalYear.
		*/
		public void set_LastYearRange(Integer value) {
			this.setInput("LastYearRange", value);
		}

		/** 
		Set the value of the LastYearRange input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies the last year in a range of years from 2000-2006; if used, must be used with FirstYearRange and without FiscalYear.
		*/
		public void set_LastYearRange(String value) {
			this.setInput("LastYearRange", value);	
		}
		/** 
		Set the value of the MajAgency input for this Choreo. 

		@param String - (conditional, string) The 2-character code for a major governmental agency providing assistance.
		*/
		public void set_MajAgency(String value) {
			this.setInput("MajAgency", value);
		}


		/** 
		Set the value of the MaxRecords input for this Choreo. 

		@param Integer - (optional, integer) Allows you to set the maximum number of records retrieved. Defaults to 100.
		*/
		public void set_MaxRecords(Integer value) {
			this.setInput("MaxRecords", value);
		}

		/** 
		Set the value of the MaxRecords input for this Choreo as a String. 

		@param String - (optional, integer) Allows you to set the maximum number of records retrieved. Defaults to 100.
		*/
		public void set_MaxRecords(String value) {
			this.setInput("MaxRecords", value);	
		}
		/** 
		Set the value of the PrincipalPlaceCC input for this Choreo. 

		@param String - (conditional, string) The city or county of the place of performance.
		*/
		public void set_PrincipalPlaceCC(String value) {
			this.setInput("PrincipalPlaceCC", value);
		}


		/** 
		Set the value of the PrincipalPlaceStateCode input for this Choreo. 

		@param String - (conditional, string) The FIPS state code for the state of the place of performance.
		*/
		public void set_PrincipalPlaceStateCode(String value) {
			this.setInput("PrincipalPlaceStateCode", value);
		}


		/** 
		Set the value of the RecipientCityName input for this Choreo. 

		@param String - (conditional, string) The city in the address of a recipient.
		*/
		public void set_RecipientCityName(String value) {
			this.setInput("RecipientCityName", value);
		}


		/** 
		Set the value of the RecipientCountyName input for this Choreo. 

		@param String - (conditional, string) The county in which a recipient is located.
		*/
		public void set_RecipientCountyName(String value) {
			this.setInput("RecipientCountyName", value);
		}


		/** 
		Set the value of the RecipientDistrict input for this Choreo. 

		@param String - (conditional, string) The Congressional District in which the recipient is located, formatted with four characters.
		*/
		public void set_RecipientDistrict(String value) {
			this.setInput("RecipientDistrict", value);
		}


		/** 
		Set the value of the RecipientName input for this Choreo. 

		@param String - (conditional, string) The name of a recipient of assistance.
		*/
		public void set_RecipientName(String value) {
			this.setInput("RecipientName", value);
		}


		/** 
		Set the value of the RecipientStateCode input for this Choreo. 

		@param String - (conditional, string) The FIPS state code for the state in the address of a recipient.
		*/
		public void set_RecipientStateCode(String value) {
			this.setInput("RecipientStateCode", value);
		}


		/** 
		Set the value of the RecipientType input for this Choreo. 

		@param String - (conditional, string) The type of recipient. Valid values are: f = For Profits, g = Government,h = Higher Education, i = Individuals,n = Nonprofits, o = Other.
		*/
		public void set_RecipientType(String value) {
			this.setInput("RecipientType", value);
		}


		/** 
		Set the value of the RecipientZip input for this Choreo. 

		@param Integer - (conditional, integer) The ZIP code in the address of a recipient.
		*/
		public void set_RecipientZip(Integer value) {
			this.setInput("RecipientZip", value);
		}

		/** 
		Set the value of the RecipientZip input for this Choreo as a String. 

		@param String - (conditional, integer) The ZIP code in the address of a recipient.
		*/
		public void set_RecipientZip(String value) {
			this.setInput("RecipientZip", value);	
		}
		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) Determines how records are sorted. Valid values: r (contractor/recipient name), f (dollars of awards),g (major contracting agency), p (CFDA Program), d (date of award). Defaults to f.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the TextSearch input for this Choreo. 

		@param String - (conditional, string) A free text search on a description of the project.
		*/
		public void set_TextSearch(String value) {
			this.setInput("TextSearch", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Assistance Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AssistanceResultSet extends ResultSet {
		public AssistanceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from FedSpending.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
