package com.temboo.Library.Twitter.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Search

Allows you to search public user accounts on Twitter.
*/
public class Search extends Choreography {

	/**
	Create a new instance of the Search Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Search(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/Users/Search"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchInputSet
	*/
	public SearchInputSet newInputSet() {
		return new SearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Search
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Count input for this Choreo. 

		@param Integer - (optional, integer) The number of potential user results to retrieve per page. This value has a maximum of 20.
		*/
		public void set_Count(Integer value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (optional, integer) The number of potential user results to retrieve per page. This value has a maximum of 20.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the IncludeEntities input for this Choreo. 

		@param Boolean - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(Boolean value) {
			this.setInput("IncludeEntities", value);
		}

		/** 
		Set the value of the IncludeEntities input for this Choreo as a String. 

		@param String - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(String value) {
			this.setInput("IncludeEntities", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Specifies the page of results to retrieve.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the page of results to retrieve.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the SearchString input for this Choreo. 

		@param String - (required, string) The string used to search for users.
		*/
		public void set_SearchString(String value) {
			this.setInput("SearchString", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Search Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchResultSet extends ResultSet {
		public SearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The rate limit ceiling for this particular request.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The number of requests left for the 15 minute window.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Reset" output from this Choreo execution

		@return String - (date) The remaining window before the rate limit resets in UTC epoch seconds.
		*/
		public String get_Reset() {
			return this.getResultString("Reset");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
