package com.temboo.Library.Twitter.Search;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Tweets

Retrieves a collection of relevant Tweets matching a specified query.
*/
public class Tweets extends Choreography {

	/**
	Create a new instance of the Tweets Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Tweets(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/Search/Tweets"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TweetsInputSet
	*/
	public TweetsInputSet newInputSet() {
		return new TweetsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TweetsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TweetsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Tweets
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TweetsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Count input for this Choreo. 

		@param Integer - (optional, integer) Specifies the number of records to retrieve. Must be less than or equal to 200. Defaults to 20.
		*/
		public void set_Count(Integer value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the number of records to retrieve. Must be less than or equal to 200. Defaults to 20.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the Geocode input for this Choreo. 

		@param String - (optional, string) Returns tweets by users located within a given radius of the given latitude/longitude. Formatted like: 37.781157,-122.398720,1mi.
		*/
		public void set_Geocode(String value) {
			this.setInput("Geocode", value);
		}


		/** 
		Set the value of the IncludeEntities input for this Choreo. 

		@param Boolean - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(Boolean value) {
			this.setInput("IncludeEntities", value);
		}

		/** 
		Set the value of the IncludeEntities input for this Choreo as a String. 

		@param String - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(String value) {
			this.setInput("IncludeEntities", value);	
		}
		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (optional, string) Restricts tweets to the given language, given by an ISO 639-1 code.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the MaxId input for this Choreo. 

		@param String - (optional, string) Returns results with an ID less than (older than) or equal to the specified ID.
		*/
		public void set_MaxId(String value) {
			this.setInput("MaxId", value);
		}


		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (required, string) A search query of up to 1,000 characters.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResultType input for this Choreo. 

		@param String - (optional, string) Specifies what type of search results you want to receive. The default is "mixed." Valid values are: mixed, recent, and popular.
		*/
		public void set_ResultType(String value) {
			this.setInput("ResultType", value);
		}


		/** 
		Set the value of the SinceId input for this Choreo. 

		@param String - (optional, string) Returns results with an ID greater than (more recent than) the specified ID.
		*/
		public void set_SinceId(String value) {
			this.setInput("SinceId", value);
		}


		/** 
		Set the value of the Until input for this Choreo. 

		@param String - (optional, date) Returns tweets generated before the given date. Date should be formatted as YYYY-MM-DD.
		*/
		public void set_Until(String value) {
			this.setInput("Until", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Tweets Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TweetsResultSet extends ResultSet {
		public TweetsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The rate limit ceiling for this particular request.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The number of requests left for the 15 minute window.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Reset" output from this Choreo execution

		@return String - (date) The remaining window before the rate limit resets in UTC epoch seconds.
		*/
		public String get_Reset() {
			return this.getResultString("Reset");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
