package com.temboo.Library.Google.Places;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PlaceDetails

Retrieve detailed information about places retrieved by the PlaceSearch Choreo.
*/
public class PlaceDetails extends Choreography {

	/**
	Create a new instance of the PlaceDetails Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PlaceDetails(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Places/PlaceDetails"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PlaceDetailsInputSet
	*/
	public PlaceDetailsInputSet newInputSet() {
		return new PlaceDetailsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PlaceDetailsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PlaceDetailsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PlaceDetails
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PlaceDetailsInputSet extends InputSet {
		/** 
		Set the value of the Key input for this Choreo. 

		@param String - (required, string) The API Key provided by Google.
		*/
		public void set_Key(String value) {
			this.setInput("Key", value);
		}


		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (optional, string) The language code, indicating in which language the results should be returned, if possible. See Choreo notes for a list of supported languages and their codes.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the PlaceID input for this Choreo. 

		@param String - (conditional, string) A textual identifier that uniquely identifies a place. PlaceIDs are returned by the PlaceSearch Choreo.
		*/
		public void set_PlaceID(String value) {
			this.setInput("PlaceID", value);
		}


		/** 
		Set the value of the Reference input for this Choreo. 

		@param String - (optional, string) A textual identifier that uniquely identifies a place. Note, this parameter is deprecated as of June 24, 2014. Use PlaceID instead.
		*/
		public void set_Reference(String value) {
			this.setInput("Reference", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sensor input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(Boolean value) {
			this.setInput("Sensor", value);
		}

		/** 
		Set the value of the Sensor input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(String value) {
			this.setInput("Sensor", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PlaceDetails Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PlaceDetailsResultSet extends ResultSet {
		public PlaceDetailsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
