package com.temboo.Library.Google.NaturalLanguage.Documents;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AnnotateText

A convenience method that provides all the features that analyzeSentiment, analyzeEntities, and analyzeSyntax provide in one call.
*/
public class AnnotateText extends Choreography {

	/**
	Create a new instance of the AnnotateText Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AnnotateText(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/NaturalLanguage/Documents/AnnotateText"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AnnotateTextInputSet
	*/
	public AnnotateTextInputSet newInputSet() {
		return new AnnotateTextInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AnnotateTextResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AnnotateTextResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AnnotateText
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AnnotateTextInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (conditional, string) The API Key provided by Google.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Content input for this Choreo. 

		@param String - (conditional, string) The content to analyze.
		*/
		public void set_Content(String value) {
			this.setInput("Content", value);
		}


		/** 
		Set the value of the EncodingType input for this Choreo. 

		@param String - (optional, string) The encoding type used by the API to calculate sentence offsets. Defaults to UTF-8.
		*/
		public void set_EncodingType(String value) {
			this.setInput("EncodingType", value);
		}


		/** 
		Set the value of the ExtractDocumentSentiment input for this Choreo. 

		@param Boolean - (optional, boolean) Extract document-level sentiment. Defaults to true.
		*/
		public void set_ExtractDocumentSentiment(Boolean value) {
			this.setInput("ExtractDocumentSentiment", value);
		}

		/** 
		Set the value of the ExtractDocumentSentiment input for this Choreo as a String. 

		@param String - (optional, boolean) Extract document-level sentiment. Defaults to true.
		*/
		public void set_ExtractDocumentSentiment(String value) {
			this.setInput("ExtractDocumentSentiment", value);	
		}
		/** 
		Set the value of the ExtractEntities input for this Choreo. 

		@param Boolean - (optional, boolean) Extract entities. Defaults to true.
		*/
		public void set_ExtractEntities(Boolean value) {
			this.setInput("ExtractEntities", value);
		}

		/** 
		Set the value of the ExtractEntities input for this Choreo as a String. 

		@param String - (optional, boolean) Extract entities. Defaults to true.
		*/
		public void set_ExtractEntities(String value) {
			this.setInput("ExtractEntities", value);	
		}
		/** 
		Set the value of the ExtractSyntax input for this Choreo. 

		@param Boolean - (optional, boolean) Extract syntax information. Defaults to true.
		*/
		public void set_ExtractSyntax(Boolean value) {
			this.setInput("ExtractSyntax", value);
		}

		/** 
		Set the value of the ExtractSyntax input for this Choreo as a String. 

		@param String - (optional, boolean) Extract syntax information. Defaults to true.
		*/
		public void set_ExtractSyntax(String value) {
			this.setInput("ExtractSyntax", value);	
		}
		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) Selector specifying which fields to include in a partial response.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the GCSContentUri input for this Choreo. 

		@param String - (optional, string) The Google Cloud Storage URI where the file content is located. This can be used instead of the Content input.
		*/
		public void set_GCSContentUri(String value) {
			this.setInput("GCSContentUri", value);
		}


		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (optional, string) The language of the document. This is specified with the ISO-639-1 Code (e.g. "en"). If not specified, the language is detected if possible.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) The type of content being sent. Valid values are PLAIN_TEXT (the default) and HTML.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AnnotateText Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AnnotateTextResultSet extends ResultSet {
		public AnnotateTextResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
