package com.temboo.Library.Google.Geocoding;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GeocodeByAddress

Converts a human-readable address into geographic coordinates.
*/
public class GeocodeByAddress extends Choreography {

	/**
	Create a new instance of the GeocodeByAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GeocodeByAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Geocoding/GeocodeByAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GeocodeByAddressInputSet
	*/
	public GeocodeByAddressInputSet newInputSet() {
		return new GeocodeByAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GeocodeByAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GeocodeByAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GeocodeByAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GeocodeByAddressInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Google.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (required, string) The address that you want to geocode.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the Bounds input for this Choreo. 

		@param String - (optional, string) The bounding box of the viewport within which to bias geocode results more prominently.
		*/
		public void set_Bounds(String value) {
			this.setInput("Bounds", value);
		}


		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (optional, string) The language in which to return results e.g.: es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the Region input for this Choreo. 

		@param String - (optional, string) The region code, specified as a ccTLD ("top-level domain") two-character value. Defaults to 'us' (United States).
		*/
		public void set_Region(String value) {
			this.setInput("Region", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sensor input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates whether or not the geocoding request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(Boolean value) {
			this.setInput("Sensor", value);
		}

		/** 
		Set the value of the Sensor input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates whether or not the geocoding request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(String value) {
			this.setInput("Sensor", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GeocodeByAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GeocodeByAddressResultSet extends ResultSet {
		public GeocodeByAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Latitude" output from this Choreo execution

		@return String - (decimal) The latitude coordinate associated with the address provided.
		*/
		public String get_Latitude() {
			return this.getResultString("Latitude");
		}
		/** 
		Retrieve the value for the "Longitude" output from this Choreo execution

		@return String - (decimal) The longitude coordinate associated with the address provided.
		*/
		public String get_Longitude() {
			return this.getResultString("Longitude");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
