package com.temboo.Library.Google.Elevation;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetPathElevation

Obtain elevation information for a path specified by a set of  geo-coordinates.
*/
public class GetPathElevation extends Choreography {

	/**
	Create a new instance of the GetPathElevation Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetPathElevation(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Elevation/GetPathElevation"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetPathElevationInputSet
	*/
	public GetPathElevationInputSet newInputSet() {
		return new GetPathElevationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetPathElevationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetPathElevationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetPathElevation
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetPathElevationInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Google.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) Specify the path for which elevation data will be obtained.  Input formats: an array of two or more lat/longitude coordinate pairs; A set of encoded coordinates using the Encoded Polyline Algorithm.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Samples input for this Choreo. 

		@param Integer - (required, integer) Enter the number of sample points.  See API docs for additional information.
		*/
		public void set_Samples(Integer value) {
			this.setInput("Samples", value);
		}

		/** 
		Set the value of the Samples input for this Choreo as a String. 

		@param String - (required, integer) Enter the number of sample points.  See API docs for additional information.
		*/
		public void set_Samples(String value) {
			this.setInput("Samples", value);	
		}
		/** 
		Set the value of the Sensor input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(Boolean value) {
			this.setInput("Sensor", value);
		}

		/** 
		Set the value of the Sensor input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(String value) {
			this.setInput("Sensor", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetPathElevation Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetPathElevationResultSet extends ResultSet {
		public GetPathElevationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
